<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

defined( 'ABSPATH' ) || exit;

global $product;
$product_id = $product->get_id();
$is_variable = $product->is_type('variable');
// Check if the product is a valid WooCommerce product and ensure its visibility before proceeding.
if ( ! is_a( $product, WC_Product::class ) || ! $product->is_visible() ) {
	return;
}
?>
<div <?php wc_product_class( 'product-card', $product ); ?>
        data-product-id="<?= $product_id ?>"
>

	<?php
	/**
	 * Hook: woocommerce_before_shop_loop_item.
	 *
	 * @hooked woocommerce_template_loop_product_link_open - 10
	 */
	do_action( 'woocommerce_before_shop_loop_item' );
    echo '<div class="product-card_image position-relative">';
        /**
         * Hook: woocommerce_before_shop_loop_item_title.
         *
         * @hooked woocommerce_show_product_loop_sale_flash - 10
         * @hooked woocommerce_template_loop_product_thumbnail - 10
         */
        do_action( 'woocommerce_before_shop_loop_item_title' );
	echo '</div>';

	/**
	 * Hook: woocommerce_shop_loop_item_title.
	 *
	 * @hooked woocommerce_template_loop_product_title - 10
	 */
	do_action( 'woocommerce_shop_loop_item_title' );

?>

      <?php if ($is_variable):
            $taxonomy = 'pa_a5';
            $variations = $product->get_available_variations();
            $default_attributes = $product->get_default_attributes();

          if ( empty($variations) || ! is_array($variations) ) {
              return;
          }

          $default_id = $variations[0]['variation_id'];
            echo '<div class="product-variations-wrapper product-volume_items" data-parent-id="' . $product->get_id() . '">';
                foreach ( $variations as $variation ) {
                    $is_default = true;
                    $attr_key = 'attribute_' . $taxonomy;
                    if ( isset( $variation['attributes'][$attr_key] ) ) {
                        $term_slug = $variation['attributes'][$attr_key];
                        $term = get_term_by( 'slug', $term_slug, $taxonomy );
                        $label = $term ? $term->name : $term_slug;

                        $cart_item_key = WC()->cart->find_product_in_cart( $variation['variation_id'] );
                        $qty_in_cart = $cart_item_key ? WC()->cart->get_cart_item( $cart_item_key )['quantity'] : 0;

                        $is_default = true;

                        foreach ( $variation['attributes'] as $attr_key => $attr_value ) {
                            if (
                                ! isset($default_attributes[str_replace('attribute_', '', $attr_key)]) ||
                                $default_attributes[str_replace('attribute_', '', $attr_key)] !== $attr_value
                            ) {
                                $is_default = false;
                                break;
                            }
                        }

                        $default_class = $is_default ? 'active' : '';
            ?>
                        <button type="button"
                        class="variation-option <?= esc_attr($default_class); ?>"
                        data-variation-id="<?= esc_attr($variation['variation_id']); ?>"
                        data-price="<?= esc_attr($variation['price_html']); ?>"
                        data-attributes='<?= esc_attr(json_encode($variation['attributes'])); ?>'
                        >
                            <?= esc_html($label); ?>
                        </button>
                      <?php
                    }
                }
            echo '</div>';

          $first_v = $variations[0];
          $first_qty = WC()->cart->find_product_in_cart( $first_v['variation_id'] );
          $initial_qty = $first_qty ? WC()->cart->get_cart_item( $first_qty )['quantity'] : 0;

          $show_qty = $initial_qty > 0 ? 'display:flex;' : 'display:none;';
          $show_add = $initial_qty > 0 ? 'display:none;' : 'display:inline-flex;'; ?>
      <?php endif; ?>

      <div class="row align-items-center product-card_footer">
          <div class="col-auto product-price" data-base-price="<?= wc_get_price_to_display($product); ?>">
              <?= $product->get_price_html(); ?>
          </div>
          <div class="col">
              <button class="add-to-cart-btn add-to-cart_button">
                  افزودن به سبد
              </button>

              <div class="qty-wrapper hidden">
                  <button class="qty-minus">−</button>
                  <input type="number" class="qty-input" value="1" min="0">
                  <button class="qty-plus">+</button>
              </div>
          </div>

      </div>
    <?php
	do_action( 'woocommerce_after_shop_loop_item' );
	?>
</div>
