<?php
/**
 * User detection.
 */
add_action('wp_ajax_unixa_auth_user_detection', 'unixa_auth_user_detection');
add_action('wp_ajax_nopriv_unixa_auth_user_detection', 'unixa_auth_user_detection');
function unixa_auth_user_detection(){
    $rules[] = "required,mobile,".'لطفا شماره موبایل خود را وارد نمایید';
    $rules[] = "valid_mobile,mobile,".'شماره موبایل وارد شده معتبر نمی باشد';

    $action = '';
    $strategy = get_field('auth_password_strategy', 'option');
    unset($_SESSION['unixa_auth']);
    $errors = validateFields($_POST, $rules);
    if (!empty($errors)) {

        foreach ($errors as $error){
            $status = 0;
            $error = "$error";
        }
        $resp = array('status' => $status, 'msg' => $error, 'action' => $action , 'strategy' => $strategy);
        header( "Content-Type: application/json" );
        echo json_encode($resp);
        die();

    } else {
        $allowed_html   =   array();
        $mobile = wp_kses(unixa_xss_clean($_POST['mobile']) ,$allowed_html);

        if(!wp_verify_nonce(unixa_xss_clean($_POST['auth_user_detection_nonce_field']),'auth_user_detection_nonce')){
            $status = 0;
            $error = 'خطا امنیتی رخ داده است';
        }else{
            if(!is_user_logged_in()){
                $user = get_user_by('login', esc_attr($mobile));
                if(!$user){
                    $status = 1;
                    $error = 'کد تایید به شماره موبایل شما پیامک شد';
                    $action = 'register';

                    $verify_mobile_template = get_field('auth_sms_verify_mobile_template', 'option');
                    $verification_code = unixa_auth_generate_random_password();
                    unixa_auth_send_sms(esc_attr($mobile),esc_attr($verify_mobile_template),esc_attr($verification_code));

                    $_SESSION['unixa_auth']['status'] = 'not-registered';
                    $_SESSION['unixa_auth']['mobile'] = esc_attr($mobile);
                    $_SESSION['unixa_auth']['verification_code'] = esc_attr($verification_code);
                }else{
                    $user_id = $user->data->ID;
                    $user_data = get_userdata(esc_attr($user_id));
                    if(in_array('customer',$user_data->roles)){
                        $success_message = 'اطلاعات كاربری يافت شد';
                        $action = 'login';

                        $_SESSION['unixa_auth']['status'] = 'registered';
                        $_SESSION['unixa_auth']['user_id'] = esc_attr($user_id);
                        $_SESSION['unixa_auth']['mobile'] = esc_attr($mobile);

                        $auth_password_strategy = get_field('auth_password_strategy', 'option');
                        if($auth_password_strategy == 'otp'){
                            $otp_template = get_field('auth_sms_otp_template', 'option');
                            $generate_password = unixa_auth_generate_random_password();
                            wp_set_password(esc_attr($generate_password),esc_attr($user_id));
                            unixa_auth_send_sms(esc_attr($mobile),esc_attr($otp_template),esc_attr($generate_password));
                            $success_message = 'رمز عبور یکبار مصرف به شماره موبایل شما پیامک شد';
                        }

                        $status = 1;
                        $error = esc_html($success_message);
                    }else{
                        $status = 0;
                        $error = 'شما از سطح دسترسی مناسب برخوردار نیستید';
                    }
                }
            }else{
                $status = 0;
                $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
            }
        }


        $resp = array('status' => $status, 'msg' => $error, 'action' => $action , 'strategy' => $strategy);
        header( "Content-Type: application/json" );
        echo json_encode($resp);
        die();
    }
}

add_action('wp_ajax_unixa_auth_user_login', 'unixa_auth_user_login');
add_action('wp_ajax_nopriv_unixa_auth_user_login', 'unixa_auth_user_login');
function unixa_auth_user_login(){
    $rules[] = "required,password,".'لطفا رمز عبور خود را وارد نمایید';
    $rules[] = "digits_only,password,".'رمز عبور باید به صورت عددی باشد';
    $rules[] = "length=6,password,".'طول رمز عبور باید 6 رقم باشد';

    $errors = validateFields($_POST, $rules);
    if (!empty($errors)) {

        foreach ($errors as $error){
            $status = 0;
            $error = "$error";
        }
        $resp = array('status' => $status, 'msg' => $error);
        header( "Content-Type: application/json" );
        echo json_encode($resp);
        die();

    } else {
        $allowed_html   =   array();
        $password = wp_kses(unixa_xss_clean($_POST['password']) ,$allowed_html);

        if(!wp_verify_nonce(unixa_xss_clean($_POST['auth_user_login_nonce_field']),'auth_user_login_nonce')){
            $status = 0;
            $error = 'خطا امنیتی رخ داده است';
        }else{
            if(!is_user_logged_in()){
                if(isset($_SESSION['unixa_auth'])){
                    if($_SESSION['unixa_auth']['status'] == 'registered'){
                        if($_SESSION['unixa_auth']['user_id']){
                            $user_id = $_SESSION['unixa_auth']['user_id'];
                            $user = get_user_by('ID', esc_attr($user_id));
                            $user_data = get_userdata(esc_attr($user_id));
                            if(in_array('customer',$user_data->roles)){
								if(wp_check_password($password, $user->user_pass, $user->ID)){
									wp_set_current_user( $user->ID, $user->user_login );
									do_action('set_current_user');
									wp_set_auth_cookie( $user->ID , false);

									unset($_SESSION['unixa_auth']);

									$status = 1;
									$error = 'با موفقیت به حساب کاربری خود وارد شدید';
								}else{
									$status = 0;
									$error = 'رمز عبور وارد شده نادرست است';
								}
                            }else{
                                $status = 0;
                                $error = 'شما از سطح دسترسی مناسب برخوردار نیستید';
                            }
                        }else{
                            $status = 0;
                            $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                        }
                    }else{
                        $status = 0;
                        $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                    }
                }else{
                    $status = 0;
                    $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                }
            }else{
                $status = 0;
                $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
            }
        }


        $resp = array('status' => $status, 'msg' => $error);
        header( "Content-Type: application/json" );
        echo json_encode($resp);
        die();
    }
}

add_action('wp_ajax_unixa_auth_user_resend_code', 'unixa_auth_user_resend_code');
add_action('wp_ajax_nopriv_unixa_auth_user_resend_code', 'unixa_auth_user_resend_code');
function unixa_auth_user_resend_code(){
    $rules[] = "required,type,".'خطایی رخ داده است، لطفا بعدا تلاش نمایید';

    $errors = validateFields($_POST, $rules);
    if (!empty($errors)) {

        foreach ($errors as $error){
            $status = 0;
            $error = "$error";
        }
        $resp = array('status' => $status, 'msg' => $error);
        header( "Content-Type: application/json" );
        echo json_encode($resp);
        die();

    } else {
        $allowed_html   =   array();
        $type = wp_kses(unixa_xss_clean($_POST['type']) ,$allowed_html);

        if(!wp_verify_nonce(unixa_xss_clean($_POST['nonce']),'auth_nonce')){
            $status = 0;
            $error = 'خطا امنیتی رخ داده است';
        }else{
            if($type == 'otp-password' or $type == 'reset-password'){
                $auth_password_strategy = get_field('auth_password_strategy', 'option');
                if(($type == 'otp-password' and $auth_password_strategy == 'otp') or ($type == 'reset-password' and $auth_password_strategy != 'otp')){
                    if(!is_user_logged_in()){
                        if(isset($_SESSION['unixa_auth'])){
                            if($_SESSION['unixa_auth']['status'] == 'registered'){
                                if($_SESSION['unixa_auth']['user_id']){
                                    $user_id = $_SESSION['unixa_auth']['user_id'];
                                    $mobile = $_SESSION['unixa_auth']['mobile'];
                                    $user_data = get_userdata(esc_attr($user_id));
                                    if(in_array('customer',$user_data->roles)){
                                        if($mobile){
                                            $otp_template = get_field('auth_sms_otp_template', 'option');
                                            $reset_password_template = get_field('auth_sms_reset_password_template', 'option');
                                            if($type == 'otp-password'){
                                                $template = $otp_template;
                                            }elseif($type == 'reset-password'){
                                                $template = $reset_password_template;
                                            }
                                            $generate_password = unixa_auth_generate_random_password();
                                            wp_set_password(esc_attr($generate_password),esc_attr($user_id));
                                            unixa_auth_send_sms(esc_attr($mobile),esc_attr($template),esc_attr($generate_password));

                                            $status = 1;
                                            $error = 'رمز عبور پیامک شد';
                                        }else{
                                            $status = 0;
                                            $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                                        }
                                    }else{
                                        $status = 0;
                                        $error = 'شما از سطح دسترسی مناسب برخوردار نیستید';
                                    }
                                }else{
                                    $status = 0;
                                    $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                                }
                            }else{
                                $status = 0;
                                $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                            }
                        }else{
                            $status = 0;
                            $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                        }
                    }else{
                        $status = 0;
                        $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                    }
                }else{
                    $status = 0;
                    $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                }
            } elseif($type == 'verification-code'){
                if(!is_user_logged_in()){
                    if(isset($_SESSION['unixa_auth'])){
                        if($_SESSION['unixa_auth']['status'] == 'not-registered'){
                            $mobile = $_SESSION['unixa_auth']['mobile'];
                            if($mobile){
                                $verify_mobile_template = get_field('auth_sms_verify_mobile_template', 'option');
                                $verification_code = unixa_auth_generate_random_password();
                                unixa_auth_send_sms(esc_attr($mobile),esc_attr($verify_mobile_template),esc_attr($verification_code));
                                $_SESSION['unixa_auth']['verification_code'] = esc_attr($verification_code);

                                $status = 1;
                                $error = 'کد تایید پیامک شد';
                            }else{
                                $status = 0;
                                $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                            }
                        }else{
                            $status = 0;
                            $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                        }
                    }else{
                        $status = 0;
                        $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                    }
                }else{
                    $status = 0;
                    $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                }
            }else{
                $status = 0;
                $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
            }
        }


        $resp = array('status' => $status, 'msg' => $error);
        header( "Content-Type: application/json" );
        echo json_encode($resp);
        die();
    }
}

add_action('wp_ajax_unixa_auth_user_register', 'unixa_auth_user_register');
add_action('wp_ajax_nopriv_unixa_auth_user_register', 'unixa_auth_user_register');
function unixa_auth_user_register(){
    $rules[] = "required,verification_code,".'لطفا کد تایید خود را وارد نمایید';
    $rules[] = "digits_only,verification_code,".'کد تایید باید به صورت عددی باشد';
    $rules[] = "length=6,verification_code,".'طول کد تایید باید 6 رقم باشد';

    $extra_step = false;
    $errors = validateFields($_POST, $rules);
    if (!empty($errors)) {

        foreach ($errors as $error){
            $status = 0;
            $error = "$error";
        }
        $resp = array('status' => $status, 'msg' => $error, 'extra_step' => $extra_step);
        header( "Content-Type: application/json" );
        echo json_encode($resp);
        die();

    } else {
        $allowed_html   =   array();
        $verification_code = wp_kses(unixa_xss_clean($_POST['verification_code']) ,$allowed_html);

        if(!wp_verify_nonce(unixa_xss_clean($_POST['auth_user_register_nonce_field']),'auth_user_register_nonce')){
            $status = 0;
            $error = 'خطا امنیتی رخ داده است';
        }else{
            if(!is_user_logged_in()){
                if(isset($_SESSION['unixa_auth'])){
                    if($_SESSION['unixa_auth']['status'] == 'not-registered'){
                        if($_SESSION['unixa_auth']['verification_code']){
                            $mobile = $_SESSION['unixa_auth']['mobile'];
                            $valid_verification_code = $_SESSION['unixa_auth']['verification_code'];
                            if($verification_code == $valid_verification_code){
                                $website_domain = auth_website_domain;
                                $email = esc_attr($mobile).'@'.esc_attr($website_domain);
                                $password = unixa_auth_generate_random_password();

                                $user_id = wp_insert_user(array(
                                    'user_pass' => apply_filters('pre_user_user_pass', $password),
                                    'user_login' => apply_filters('pre_user_user_login', $mobile),
                                    'user_email' => apply_filters('pre_user_user_email', $email),
                                    'show_admin_bar_front' => 'false',
                                    'role' => 'customer' ));
                                if(is_wp_error($user_id)){
                                    $status = 0;
                                    $error = 'کاربری با این شماره موبایل قبلا در سایت عضو شده است';
                                }else{
                                    //do_action('user_register', esc_attr($user_id));
                                    update_user_meta(esc_attr($user_id), 'mobile', esc_attr($mobile));

                                    $_SESSION['unixa_auth']['status'] = 'registered-now';
                                    $_SESSION['unixa_auth']['user_id'] = esc_attr($user_id);


                                    $password_strategy = get_field('auth_password_strategy', 'option');
                                    $simple_register_template = get_field('auth_sms_register_template', 'option');

                                    $success_message = 'عضویت شما با موفقیت انجام شد';
                                    unixa_auth_send_sms(esc_attr($mobile),esc_attr($simple_register_template),'شد');


                                    $status = 1;
                                    $error = esc_html($success_message);
                                    $extra_step = true;
                                }
                            }else{
                                $status = 0;
                                $error = 'کد تایید وارد شده نادرست است';
                            }
                        }else{
                            $status = 0;
                            $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                            alert('mina');
                        }
                    }else{
                        $status = 0;
                        $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                        alert('minaa');
                    }
                }else{
                    $status = 0;
                    $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                    alert('minaaa');
                }
            }else{
                $status = 0;
                $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                alert('minaaaa');
            }
        }


        $resp = array('status' => $status, 'msg' => $error, 'extra_step' => $extra_step);
        header( "Content-Type: application/json" );
        echo json_encode($resp);
        die();
    }
}

add_action('wp_ajax_unixa_auth_user_profile', 'unixa_auth_user_profile');
add_action('wp_ajax_nopriv_unixa_auth_user_profile', 'unixa_auth_user_profile');
function unixa_auth_user_profile(){
    $password_strategy = get_field('auth_password_strategy', 'option');

    $rules[] = "required,first_name,".'لطفا نام خود را وارد نمایید';
    $rules[] = "required,last_name,".'لطفا نام خانوادگی خود را وارد نمایید';

    $rules[] = "required,email,".'لطفا ایمیل خود را وارد نمایید';
    $rules[] = "valid_email,email,".'ایمیل وارد شده معتبر نمی باشد';

    if($password_strategy == 'user_choice'){
        $rules[] = "required,new_password,".'لطفا رمز عبور خود را وارد نمایید';
        $rules[] = "digits_only,new_password,".'رمز عبور باید به صورت عددی باشد';
        $rules[] = "length=6,new_password,".'طول رمز عبور باید 6 رقم باشد';
    }

    $rules[] = "required,gender,".'لطفا جنسیت خود را وارد نمایید';

    $errors = validateFields($_POST, $rules);
    if (!empty($errors)) {

        foreach ($errors as $error){
            $status = 0;
            $error = "$error";
        }
        $resp = array('status' => $status, 'msg' => $error);
        header( "Content-Type: application/json" );
        echo json_encode($resp);
        die();

    } else {
        $allowed_html   =   array();

        if(!wp_verify_nonce(unixa_xss_clean($_POST['auth_user_profile_nonce_field']),'auth_user_profile_nonce')){
            $status = 0;
            $error = 'خطا امنیتی رخ داده است';
        }else{
            if(!is_user_logged_in()){
                if(isset($_SESSION['unixa_auth'])){
                    if($_SESSION['unixa_auth']['status'] == 'registered-now'){
                        if($_SESSION['unixa_auth']['user_id']){
                                $user_id = $_SESSION['unixa_auth']['user_id'];
                                $user_data = get_userdata(esc_attr($user_id));
                                if(in_array('customer',$user_data->roles)){
                                    $first_name = wp_kses(unixa_xss_clean($_POST['first_name']) ,$allowed_html);
                                    $last_name = wp_kses(unixa_xss_clean($_POST['last_name']) ,$allowed_html);

                                    update_user_meta(esc_attr($user_id),'first_name',sanitize_text_field($first_name));
                                    update_user_meta(esc_attr($user_id),'billing_first_name',sanitize_text_field($first_name));
                                    update_user_meta(esc_attr($user_id),'last_name',sanitize_text_field($last_name));
                                    update_user_meta(esc_attr($user_id),'billing_last_name',sanitize_text_field($last_name));

                                    $user_args = array(
                                        'ID'           => esc_attr($user_id),
                                        'display_name' => esc_html($first_name).' '.esc_html($last_name),
                                    );
                                    wp_update_user($user_args);


                                    $email = wp_kses(unixa_xss_clean($_POST['email']) ,$allowed_html);
                                    update_user_meta(esc_attr($user_id),'billing_email',sanitize_email($email));

                                    $gender = wp_kses(unixa_xss_clean($_POST['gender']) ,$allowed_html);
                                    update_user_meta(esc_attr($user_id),'gender',sanitize_text_field($gender));

                                    if($password_strategy == 'user_choice'){
                                        $new_password = wp_kses(unixa_xss_clean($_POST['new_password']) ,$allowed_html);
                                        wp_set_password(esc_attr($new_password),esc_attr($user_id));
                                    }

                                    $user = get_user_by('ID', esc_attr($user_id));
                                    wp_set_current_user( $user->ID, $user->user_login );
                                    do_action('set_current_user');
                                    wp_set_auth_cookie( $user->ID , false);

                                    unset($_SESSION['unixa_auth']);

                                    $status = 1;
                                    $error = 'اطلاعات وارد شده با موفقيت ثبت شد';
                                }else{
                                    $status = 0;
                                    $error = 'شما از سطح دسترسی مناسب برخوردار نیستید';
                                }
                        }else{
                            $status = 0;
                            $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                        }
                    }else{
                        $status = 0;
                        $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                    }
                }else{
                    $status = 0;
                    $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
                }
            }else{
                $status = 0;
                $error = 'خطایی رخ داده است، لطفا بعدا تلاش نمایید';
            }
        }


        $resp = array('status' => $status, 'msg' => $error);
        header( "Content-Type: application/json" );
        echo json_encode($resp);
        die();
    }
}
