<?php $season_id = get_field('season_name', 'option'); ?>
<section class="season-offer">
    <div class="container">
        <div class="row">
            <?php if(get_field('season_title' , 'option')!='') { ?>
                <div class="col-12 section-title_wrapper">
                    <h2 class="home-title"><?php the_field('season_title' , 'option'); ?></h2>
                </div>
            <?php } ?>

            <div class="col-12 position-relative">
                <div class="swiper season-swiper">
                    <div class="swiper-wrapper">
                        <?php
                        $args = array(
                            'post_type' => 'product',
                            'posts_per_page' => 10,
                            'meta_query' => array(
                                array(
                                    'key' => 'is_season',
                                    'compare' => '=',
                                    'value' => '1'
                                ),
                            ),
                        );
                        if ($season_id) {
                            $args['tax_query'] = array(
                                array(
                                    'taxonomy' => 'product_season',
                                    'field'    => 'term_id',
                                    'terms'    => (int) $season_id,
                                ),
                            );
                        }

                        $season_query = new WP_Query($args);
                        if ($season_query->have_posts()) {
                            while ($season_query->have_posts()) : $season_query->the_post();
                                echo '<div class="swiper-slide">';
                                get_template_part('woocommerce/content', 'product');
                                echo '</div>';
                            endwhile;
                        }
                        wp_reset_postdata();
                        ?>
                    </div>
                </div>
                <!-- Navigation buttons -->
                <div class="swiper-button-prev"></div>
                <div class="swiper-button-next"></div>
            </div>
        </div>
    </div>
</section>

