<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta content="telephone=no" name="format-detection">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
    <link rel="shortcut icon" type="image/png" href="<?php //echo $options['favicon']['url']; ?>"/>
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<header class="site-header <?php echo !is_home() || !is_front_page() ? 'inner-header' : ''; ?>" id="header">
    <div class="container">
        <div class="row justify-content-between align-items-center top-header">
            <div class="col-3">
                <div class="mobile-menu-btn d-inline-flex d-lg-none">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/menu.svg" width="24" height="24" alt="menu" />
                </div>
                <?php
                /* logo */
                $logo = get_field('logo', 'option');
                if ($logo) {
                    echo '<div class="site-logo d-inline-flex"><a class="logo-header" href="' . get_bloginfo('url') . '" title="' . get_bloginfo('name') . '">';
                    echo '<img src="' . $logo['url'] . '" width="' . $logo['width'] . '" height="' . $logo['height'] . '" alt="' . get_bloginfo('name') . '" />';
                    echo '</a> </div>';
                }
                ?>
            </div>
            <div class="col-9 col-md-7 col-lg-5">
                <div class="row align-items-center justify-content-end position-relative">
                    <div class="form-search-wrapper col">
                        <form action="<?php get_bloginfo('url'); ?>" class="ajax-search" role="search" method="get" id="search-form">
                            <span class="icon-wrapper"><i class="icon-search"></i></span>
                            <input class="search-form-input form-control mb-0" type="search" value="" name="s" id="s"
                                   placeholder="جست و جو">
                            <input type="hidden" name="post_type" value="product">
                        </form>
                        <div class="search-results-box"></div>
                    </div>
                    <div class="quick-button mini-cart col-auto">
                        <button data-bs-toggle="offcanvas" data-bs-target="#offcanvasCart" type="button" aria-controls="offcanvasCart" class="theme-button position-relative">
                            <i class="icon-cart"></i>
                            <span class="counter cart-count-icon" id="cart-count">
                                <?php
                                    $cart_count = WC()->cart->get_cart_contents_count();
                                    echo sprintf(_n('%d', '%d', $cart_count), $cart_count);
                                ?>
                            </span>
                            سبد خرید
                        </button>
                    </div>
                    <div class="quick-button user-login col-auto">
                        <?php
                        if (!is_user_logged_in()) {
                            echo '<a type="button" class="unixa-auth-modal-btn theme-button secondary" data-bs-toggle="modal" data-bs-target="#unixa-auth-modal"><i class="icon-user"></i>ورود</a>';
                        } else {
                            ?>
                            <ul class="user-loggedIn position-relative">
                                <li>
                                    <?php $user_info = get_userdata(get_current_user_id()); ?>
                                    <a href="<?php echo get_permalink(wc_get_page_id('myaccount')); ?>">
                                        <span>
                                            خوش آمدی
                                            <i class="icon-chevron-down"></i>
                                        </span>
                                    </a>
                                    <ul class="submenu_profile m-0 p-0">
                                        <li>
                                            <a href="<?php echo get_permalink(wc_get_page_id('myaccount')); ?>">
                                                <?php if ($user_info->last_name != '') {
                                                    echo $user_info->last_name;
                                                } else {
                                                    echo $user_info->user_login;
                                                }
                                                ?>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="<?php echo wp_logout_url(site_url()); ?>">خروج</a>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="row align-items-center">
            <div class="col col-sm-6 col-lg-9 col-right">
                <nav class="primary-nav d-none d-lg-inline-flex">
                    <?php
                    if (has_nav_menu('main')) {
                        $defaults = array(
                            'theme_location' => 'main',
                            'container' => '',
                            'menu_class' => 'd-flex primary-menu',
                            'echo' => true,
                            'fallback_cb' => 'wp_page_menu',
                            'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                            'depth' => 3,
                        );
                        wp_nav_menu($defaults);
                    }
                    ?>
                </nav>
            </div>
            <?php
            $support_phone = get_field('support_phone', 'option');
            if($support_phone!='') { ?>
            <div class="col col-sm-6 col-lg-3 col-left">
                <div class="header-cta-wrapper d-flex align-items-center">
                    <span>
                        <i></i>
                        شماره تماس و پشتیبانی
                    </span>
                    <a href="tel:<?php echo $support_phone; ?>" class="header-cta"><?php echo $support_phone; ?></a>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>
</header>

<div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasCart" aria-labelledby="offcanvasCartLabel">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title" id="offcanvasCartLabel">سبد خرید</h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <div class="woo-mini-cart">
            <div class="widget_shopping_cart_content">
                <?php woocommerce_mini_cart(); ?>
            </div>
        </div>
    </div>
</div>
<main class="main-content <?php echo !is_home() || !is_front_page() ? 'inner-main' : ''; ?>">

<?php //if (!is_home() || !is_front_page()) { get_template_part('templates/content/breadcrumb'); } ?>
