<?php
function normalize_search_keyword($text) {
    $map = [
        'آ' => 'ا', 'أ' => 'ا', 'إ' => 'ا',
        'ي' => 'ی', 'ئ' => 'ی',
        'ك' => 'ک',
        'ة' => 'ه', 'ۀ' => 'ه',
        ' ' => '', '‌' => '' // حذف فاصله و نیم‌فاصله
    ];
    return strtr($text, $map);
}

add_action('wp_ajax_precise_woo_search', 'precise_woo_search_callback');
add_action('wp_ajax_nopriv_precise_woo_search', 'precise_woo_search_callback');

function precise_woo_search_callback() {
    global $wpdb;

    if (ob_get_length()) ob_clean();

    $keyword = isset($_POST['keyword']) ? sanitize_text_field($_POST['keyword']) : '';

    if (empty($keyword)) {
        wp_die();
    }

    $clean_keyword = normalize_search_keyword($keyword);

    $query = "
        SELECT ID, post_title FROM {$wpdb->posts} 
        WHERE post_type = 'product' 
        AND post_status = 'publish' 
        AND (
            REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(post_title, ' ', ''), '‌', ''), 'آ', 'ا'), 'ي', 'ی'), 'ك', 'ک'), 'ة', 'ه') 
            LIKE %s
        )
        LIMIT 10";

    $results = $wpdb->get_results($wpdb->prepare($query, '%' . $wpdb->esc_like($clean_keyword) . '%'));

    if ($results) {
        echo '<ul class="search-result_list horizontal-card_list">';
        foreach ($results as $post) {
            $product = wc_get_product($post->ID);
            $image = get_the_post_thumbnail_url($post->ID, 'thumbnail') ?: wc_placeholder_img_src();
            $price = $product->get_price_html();

            echo '<li class="search-result_item horizontal-card">';
        ?>
            <div class="discount-product_right horizontal-card_right">
                <a class="product-image" href="<?php echo get_permalink( $product->get_id() ); ?>">
                    <?php echo $product->get_image( 'woocommerce_thumbnail' ); ?>
                </a>
                <div class="discount-product_info horizontal-card_info">
                    <h3 class="product-title">
                        <a href="<?php echo get_permalink( $product->get_id() ); ?>">
                            <?php echo $product->name; ?>
                        </a>
                    </h3>

                    <div class="product-price">
                        <?php echo $price; ?>
                    </div>
                </div>
            </div>
            <div class="discount-product_left horizontal-card_left">
                <a class="discount-product_cart add-to-cart_button" href="<?php echo get_permalink( $product->get_id() ); ?>">
                    <i class="icon-cart"></i>
                </a>
                <?php
                $a5_terms = wc_get_product_terms(
                    $product->get_id(),
                    'pa_a5',
                    array( 'fields' => 'names' )
                );

                if ( ! empty( $a5_terms ) && ! is_wp_error( $a5_terms ) ) :
                    ?>
                    <div class="product-volume_items d-flex">
                        <?php foreach ( $a5_terms as $term_name ) : ?>
                            <span class="variant"><?php echo esc_html( $term_name ); ?></span>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        <?php
            echo '</li>';
        }
        echo '</ul>';
        echo '<a href="' . home_url('/?s=' . $keyword . '&post_type=product') . '" class="theme-button large">مشاهده همه نتایج...</a>';
    } else {
        echo '<div class="no-result col-12">محصولی پیدا نشد.</div>';
    }

    wp_die();
}
