<?php
/* Template Name: About Us*/
get_header();
?>
<div class="page-wrap about-page">
    <div class="container post-single">
        <div class="row section-one">
            <div class="col-12 col-lg-5">
                <?php if (has_post_thumbnail()) { ?>
                    <div class="page-thumbnail wow fadeInUp" data-wow-delay="0.25s">
                        <span class="fill-circle big"></span>
                        <span class="fill-circle small"></span>
                        <span class="fill-star"></span>
                        <span class="circle"></span>
                        <span class="polygon"></span>
                        <?php the_post_thumbnail(); ?>
                    </div>
                <?php } ?>
            </div>
            <div class="col-12 col-lg-7">
                <h1 class="about-title wow fadeInUp" data-wow-delay="0.25s">
                    <?php the_field('about_title'); ?>
                </h1>
                <div class="entry-content wow fadeInUp" data-wow-delay="0.5s">
                    <?php the_field('about_text'); ?>
                </div>
            </div>
        </div>

        <div class="row section-two">
            <div class="col-12">
                <?php the_field('abou_text2'); ?>
            </div>
        </div>

        <div class="row section-three">
            <div class="col-12 col-lg-7">
                <div class="entry-content wow fadeInUp" data-wow-delay="0.5s">
                    <?php the_field('goal_text'); ?>
                </div>
            </div>
            <div class="col-12 col-lg-5">
                <?php $image = get_field('goal_image');
                if ($image) { ?>
                    <div class="page-thumbnail wow fadeInUp" data-wow-delay="0.25s">
                        <span class="fill-circle big"></span>
                        <span class="fill-circle small"></span>
                        <span class="fill-star"></span>
                        <span class="circle"></span>
                        <span class="polygon"></span>
                        <img src="<?php echo $image['url']; ?>" width="<?php echo $image['width']; ?>"
                             height="<?php echo $image['height']; ?>" alt="<?php echo $image['alt']; ?>">
                    </div>
                <?php } ?>
            </div>
        </div>

        <div class="row section-four">
            <div class="col-12">
                <div class="entry-content wow fadeInUp" data-wow-delay="0.5s">
                    <?php
                    if (have_posts()) :
                        while (have_posts()) : the_post();
                            the_content();
                        endwhile;
                    endif;
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php get_footer(); ?>
