<?php $terms = get_field('blog_cat', 'option'); 
if($terms) {
    $i = 1; foreach( $terms as $term ):
    $term_name = get_the_category_by_ID($term);
    $term_link = get_term_link($term);
    $term_icon = get_field('_icon', 'category_'. $term);
    $args = array(
        'cat' => $term,
        'posts_per_page' => 3,
        'post_status' => 'publish'
    );
    $query = new WP_Query( $args );
    if ( $query->have_posts() ) :
?>
<section class="category-section <?php echo $i == 1 ? 'with-border' : ''; ?>" id="section-<?php echo esc_attr($term); ?>">
    <div class="container-lg">
        <div class="row align-items-center section-head">
            <div class="col">
                <h2 class="section-title fs-4 fw-medium">
                    <?php if ( $term_icon ) :
                        echo '<img 
                            src="'. esc_url($term_icon) .'" 
                            alt="'. esc_attr(get_the_category_by_ID($term)) .'" 
                            class="category-icon medium-24"
                            width="32"
                            height="32"
                        />';
                    endif ?> 
                    <?php echo esc_html($term_name); ?>
                </h2>
            </div>
            <div class="col-auto d-none d-sm-block">
                <a class="more-btn_text text-btn" href="<?php echo esc_url($term_link); ?>">
                    بیشتر
                    <i class="icon-arrow-left"></i>
                </a>
            </div>
        </div>
        <?php 
           
        ?>
        <div class="row row-scrollable">
            <?php while ( $query->have_posts() ) : $query->the_post(); ?>
            <div class="col-10 col-sm-8 col-md-4">
                <?php get_template_part('templates/card/blog', 'card'); ?>
            </div>
            <?php
                endwhile;
                wp_reset_postdata(); 
            ?>
        </div>
    </div>
</section>
<?php $i++; endif; endforeach; } ?>