<?php
get_header();
$paged = (get_query_var('paged')) ? get_query_var('paged') : ((get_query_var('page')) ? get_query_var('page') : 1);
global $wp_query;
$tag_id = $wp_query->get_queried_object_id();
?>
<div class="page-wrap category-blog">
    <?php if (tag_description() != '') { ?>
        <div class="page-description">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <?php echo tag_description(); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>
    <section class="archive-list">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h1 class="page-title"><?php echo single_tag_title(); ?></h1>
                </div>
                <?php
                $args = array(
                    'post_type' => 'post',
                    'paged' => $paged,
                    'post_status ' => 'publish',
                    'tag_id' => $tag_id,
                );
                $posts = new WP_Query($args);
                if ($posts->have_posts()):
                    while ($posts->have_posts()) : $posts->the_post();
                ?>
                    <div class="col-10 col-md-4 mb-4">
                        <?php get_template_part('templates/card/blog', 'card'); ?>
                    </div>
                <?php endwhile;
                endif;
                wp_reset_postdata();
                ?>
                <div class="col-12">
                    <div class="site-pagination">
                        <?php pagination_bar($posts); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php get_footer(); ?>


