<?php
/*
**************   COMMENT DESIGN   **************
*/
add_filter('comment_author', 'custom_comment_author', 10, 2);

function custom_comment_author($author, $commentID)
{
    $comment = get_comment($commentID);
    $user = get_user_by('email', $comment->comment_author_email);
    if (!$user):
        return $author;
    endif;
}

function tiyara_comment($comment, $args, $depth) {
    $GLOBALS['comment'] = $comment;
    $tag = 'div';
    ?>
    <<?php echo $tag; ?> <?php comment_class(empty($args['has_children']) ? '' : 'parent'); ?> id="comment-<?php comment_ID(); ?>">
        <div id="div-comment-<?php comment_ID(); ?>" class="comment-card">
            <?php if ($comment->comment_approved == '0') : ?>
                <em class="comment-awaiting-moderation"><?php esc_html_e('Your comment is awaiting moderation.'); ?></em>
            <?php endif; ?>

            <div class="comment-inner d-flex">
                <div class="comment-avatar">
                    <?php echo get_avatar($comment, 64); ?>
                </div>
                <div class="comment-text">
                    <?php comment_text(); ?>
                </div>
            </div>
        </div>
    </div>
    <?php
}


//Comments
if (!function_exists('tiyara_comment_form')) {
    function tiyara_comment_form($args = array(), $post_id = null)
    {
        $post_id = get_the_ID();

        $commenter = wp_get_current_commenter();
        $user = wp_get_current_user();
        $user_identity = $user->exists() ? $user->display_name : '';

        if (!isset($args['format']))
            $args['format'] = current_theme_supports('html5', 'comment-form') ? 'html5' : 'xhtml';

        $html5 = 'html5' === $args['format'];
        $fields = array(
            'comment_field' => '<div class="col-12 comment-field">
            <textarea class="form-control comment-message" id="comment" name="comment" placeholder="' . esc_attr__('پیام خود را اینجا بنویسید', 'tiyara') . '" rows="4" aria-required="true"></textarea>
			</div>',
            'submit' => '<div class="col-12 col-md-5 form-submit">
			<input class="theme-button primary-button" id="submit" name="submit" type="submit" value="' . esc_attr__('ثبت نظر', 'tiyara') . '" />',
        );

        $defaults = array(
            'fields' => apply_filters('comment_form_default_fields', $fields),
            'comment_field' => '',
            'must_log_in' => '<div class="alert alert-danger must-log-in">' . 
                sprintf(
                    esc_html__('برای ارسال دیدگاه باید ابتدا وارد شوید. %s', 'tiyara'),
                    '<a href="' . esc_url(wp_login_url(get_permalink($post_id))) . '">' . esc_html__('ورود', 'tiyara') . '</a>'
                ) 
                . '</div>',
            'logged_in_as' => '<div class="alert-by-comment mb-3"><div class="logged-in-as">' . sprintf(__(' نام کاربری: <span>%2$s</span> <a href="%3$s" title="Log out of this account" class="trn_elm_logout">خروج</a>', 'tiyara'), get_bloginfo('url') . '/profile/?id=' . $user->id, $user_identity, wp_logout_url(apply_filters('the_permalink', get_permalink($post_id)))) . '</div></div><div class="col-12 form-group comment-form-comment">
			<div class="row login_textarea">
			<div class="col-12 comment-field">
				<textarea class="form-control comment-message" id="comment" name="comment" placeholder="' . _x('پیام خود را اینجا بنویسید', 'noun', 'tiyara') . '" rows="4" aria-required="true"></textarea>
			</div>
			<div class="col-12 col-md-5 form-submit"><input class="theme-button primary-button" id="submit" name="submit" type="submit" value="' . esc_attr__('ثبت نظر', 'tiyara') . '"  /></div></div>',
            'comment_notes_before' => '',
            'comment_notes_after' => '<div class="form-allowed-tags">' . sprintf(__('You may use these <abbr title="HyperText Markup Language">HTML</abbr> tags and attributes: %s', 'tiyara'), ' <code>' . allowed_tags() . '</code>') . '</div>',
            'id_form' => 'commentform',
            'id_submit' => 'submit',
            'title_reply' => esc_html__('ارسال دیدگاه', 'tiyara'),
            'title_reply_to' => esc_html__('پاسخ به %s', 'tiyara'),
            'cancel_reply_link' => esc_html__('انصراف', 'tiyara'),
            'label_submit' => esc_html__('ارسال نظر', 'tiyara'),
            'format' => 'xhtml',
        );

        $args = wp_parse_args($args, apply_filters('comment_form_defaults', $defaults));
        if (comments_open($post_id)) {
            do_action('comment_form_before'); ?>
            <div id="respond" class="comment-respond">
            <?php
            if (is_user_logged_in()) {
                $class = "login";
            } else {
                $class = " ";
            }
            ?>
            <h3 id="reply-title" class="comment-reply-title <?php echo esc_attr($class); ?>">
                <small><?php cancel_comment_reply_link($args['cancel_reply_link']); ?></small>
            </h3>
            <?php if (get_option('comment_registration') && !is_user_logged_in()) {
                echo $args['must_log_in'];
                do_action('comment_form_must_log_in_after');
            } else { ?>
                <form action="<?php echo esc_url(site_url('/wp-comments-post.php')); ?>" method="post"
                      id="<?php echo esc_attr($args['id_form']); ?>"
                      class="form-horizontal row comment-form"<?php echo $html5 ? ' novalidate' : ''; ?> >
                    <?php do_action('comment_form_top');
                    if (is_user_logged_in()) {
                        echo apply_filters('comment_form_logged_in', $args['logged_in_as'], $commenter, $user_identity);
                        do_action('comment_form_logged_in_after', $commenter, $user_identity);
                    } else {
                        echo $args['comment_notes_before'];
                        do_action('comment_form_before_fields');
                        foreach ((array)$args['fields'] as $name => $field) {
                            echo apply_filters("comment_form_field_{$name}", $field) . "\n";
                        }
                        do_action('comment_form_after_fields');
                    }
                    echo apply_filters('comment_form_field_comment', $args['comment_field']);
                    echo $args['comment_notes_after'];
                    comment_id_fields($post_id);
                    do_action('comment_form', $post_id); ?>
                </form>
                </div>
            <?php }
            do_action('comment_form_after');
        } else {
            do_action('comment_form_comments_closed');
        }
    }
}
?>
