<?php
get_header();
global $wp_query;
$paged = (get_query_var('paged')) ? get_query_var('paged') : ((get_query_var('page')) ? get_query_var('page') : 1);
$cat_id = $wp_query->get_queried_object_id();
$image = get_field('_icon', 'category_'. $cat_id);
?>
<div class="page-wrap category-blog">
    <section class="archive-list">
        <?php 
        $categories = get_categories([
            'orderby' => 'name',
            'order'   => 'ASC',
            'hide_empty' => true, 
        ]);

        if ( $categories ) : 
            $current_cat = get_queried_object(); 
        ?>
        <div class="category-nav_wrapper pt-0">
            <div class="container-lg">
                <div class="row">
                    <div class="col-12 col-md-7 mx-auto">
                        <div class="category-nav text-center">
                            <span class="category-nav_title">دسته‌بندی مطالب</span>
                            <ul class="category-nav_menu d-flex align-items-center justify-content-center">
                                <?php foreach( $categories as $cat ): 
                                    $term_link = get_category_link($cat->term_id);
                                    $active_class = ( isset($current_cat->term_id) && $current_cat->term_id == $cat->term_id ) ? 'active' : '';
                                    $term_icon = get_field('_icon', 'category_'. $cat->term_id);
                                ?>
                                <li class="category-nav_menu_item <?php echo esc_attr($active_class); ?>">
                                    <a href="<?php echo esc_url($term_link); ?>">
                                        <?php if ( $term_icon ) :
                                            $icon_alt =  get_cat_name($cat->term_id);
                                            echo '<img 
                                                src="'. esc_url($term_icon) .'" 
                                                alt="'. esc_attr($icon_alt) .'" 
                                                class="category-icon"
                                                width="32"
                                                height="32"
                                            />';
                                        endif ?>
                                        <?php echo esc_html($cat->name); ?>
                                    </a>
                                </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <div class="container-lg">
            <div class="row">
                <div class="col-12 category-header">
                    <?php if ( $image ) :
                        $icon_alt =  get_cat_name($cat_id);
                        echo '<img 
                            src="'. esc_url($image) .'" 
                            alt="'. esc_attr($icon_alt) .'" 
                            class="category-icon medium-24"
                            width="32"
                            height="32"
                        />';
                    endif ?>
                    <h1 class="page-title fs-4 fw-medium with-icon"><?php echo single_cat_title(); ?></h1>
                    <?php  if (category_description() != '') {  echo category_description(); } ?>
                </div>

                <?php
                $args = array(
                    'post_type' => 'post',
                    'paged' => $paged,
                    'post_status ' => 'publish',
                    'cat' => $cat_id,
                );
                $posts = new WP_Query($args);
                if ($posts->have_posts()):
                    while ($posts->have_posts()) : $posts->the_post();
                        ?>
                        <div class="col-12 col-sm-6 col-md-4 ui-mb-20">
                            <?php get_template_part('templates/card/blog', 'card'); ?>
                        </div>
                        <?php
                        endwhile;
                endif;
                wp_reset_postdata();
                ?>
                <div class="col-12">
                    <div class="site-pagination">
                        <?php pagination_bar($posts); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php get_footer(); ?>
