(function() {
    tinymce.create('tinymce.plugins.MyCustomCard', {
        init : function(ed, url) {
            ed.addButton('my_custom_card', {
                title : 'Insert Custom Card',
                // icon : 'icon dashicons-welcome-add-page',
                text: 'Card',
                onclick : function() {
                    ed.windowManager.open({
                        width: 500,
                        height: 300,
                        title: 'کارت تبلیغاتی',
                        body: [
                            {type: 'textbox', name: 'text', label: 'عنوان کارت'},
                            {type: 'textbox', name: 'btnText', label: 'متن دکمه', value: 'کلیک کنید'},
                            {type: 'textbox', name: 'btnLink', label: 'لینک دکمه', value: '#'},
                            {type: 'textbox', name: 'imageUrl', label: 'آدرس تصویر', value: 'https://via.placeholder.com/300'}
                        ],
                        onsubmit: function(e) {
                            var content = `
                                <div class="custom-card" style="border:1px solid #ccc; display:flex; gap:20px; align-items:center;justify-content: space-between">
                                    <div class="d-flex align-items-center">
                                        <div class="card-image"><img src="${e.data.imageUrl}" style="width:150px; height:auto;margin:0" /></div>
                                        <div class="card-content">
                                            <p>${e.data.text}</p>
                                        </div>
                                    </div>
                                    <div class="card-button">
                                        <a href="${e.data.btnLink}" class="theme-button secondary-button">${e.data.btnText}</a>
                                    </div>
                                </div><br/>
                            `;
                            ed.insertContent(content);
                        }
                    });
                }
            });
        },
        createControl : function(n, cm) {
            return null;
        }
    });
    tinymce.PluginManager.add('my_custom_card', tinymce.plugins.MyCustomCard);
})();

