<?php
/**
 * My Account navigation
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/navigation.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

do_action( 'woocommerce_before_account_navigation' );

$file_store_status = false;
if (class_exists('Redux')) {
    $file_store_status = keloncloud_option('file_store_status');
}

?>

<nav class="woocommerce-MyAccount-navigation">
	<div class="user-info-MyAccount">
	
		<?php
			global $current_user;   
			echo get_avatar( $current_user->ID, 80 );
		?>

		<div class="user-info-name">سلام <strong><?php global $current_user;
			echo $current_user->display_name  ?> </strong>
		 عزیز!
		</div>

        <?php if (class_exists( 'WeDevs_Dokan' )): ?>
            <?php if (dokan_is_user_seller( get_current_user_id() )): ?>
                <a href="<?php echo dokan_get_navigation_url() ?>" style="background: #fff; border-radius: 4px; padding: 5px; display: block;margin-top: 10px;">
                    <?php if ($file_store_status): ?>
                        <span>داشبورد فروشندگان</span>
                    <?php else: ?>
                        <span>داشبورد مدرسان</span>
                    <?php endif; ?>
                </a>
            <?php endif; ?>
        <?php endif; ?>
	</div>
	
	<ul>
		<?php foreach ( wc_get_account_menu_items() as $endpoint => $label ) : ?>
			<li class="<?php echo wc_get_account_menu_item_classes( $endpoint ); ?>">
				<a href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint ) ); ?>"><?php echo esc_html( $label ); ?></a>
			</li>
		<?php endforeach; ?>
	</ul>
</nav>

<?php do_action( 'woocommerce_after_account_navigation' ); ?>
