<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}

add_filter( 'excerpt_length', 'keloncloud_product_custom_excerpt_length', 999 );

// Custom Meta
$sale_price = $product->get_sale_price();
$regular_price = $product->get_regular_price();
$prefix = '_keloncloud_';
$teacher_id = get_post_meta( get_the_ID(), $prefix . 'course_teacher', true );
$stock = get_post_meta( get_the_ID(), '_stock', true );

$vip_status = false;
if (is_plugin_active('restrict-content-pro/restrict-content-pro.php')){
    $vip_status = get_post_meta(get_the_ID(), $prefix . 'course_vip_access', true);
}

$course_students = true;
if ( class_exists( 'Redux' ) ) {
	$course_students = keloncloud_option('course_students');
}


?>
<div <?php post_class( 'course-item' ); ?>>

<!--    --><?php //do_action( 'woocommerce_before_shop_loop_item' ); ?>

    <div class="course-item-inner">

	    <?php if ( has_post_thumbnail( ) ) : ?>
            <div class="course-thumbnail-holder">
                <?php woocommerce_template_loop_product_link_open(); ?>
                    <span class="image-item">
                        <?php the_post_thumbnail('keloncloud-course-thumb', array('class'=>'img-fluid')); ?>
                    </span>
                <?php woocommerce_template_loop_product_link_close(); ?>

                <div class="btn-section">
                    <?php if ($course_video) : ?>
                        <div class="video-button">
                            <a data-post-id="<?php echo get_the_ID(); ?>"
                               href="<?php echo esc_url($course_video); ?>"
                               class="cdb-video-icon video-thumbnail"><i class="fal fa-play"></i></a>
                        </div>
                    <?php endif; ?>
                    <?php if ($courses_cart_loop) : ?>
                        <?php woocommerce_template_loop_add_to_cart(); ?>
                    <?php endif; ?>
                </div>
            </div>
	    <?php endif; ?>

        <div class="course-content-holder">

            <div class="course-content-main">
                <h4 class="course-title">
                    <a href="<?php the_permalink() ?>"><?php the_title(); ?></a>
                </h4>
	            <?php $comments_num = get_comments_number(get_the_id()); ?>
                <div class="course-description">
	                <?php the_excerpt(); ?>
                </div>
            </div>

            <div class="course-content-bottom">

                <?php if (!$vip_status): ?>
	              <div class="course-students">
				<?php if ( $course_students ) : ?>
                                    <i class="fal fa-users"></i><span><?php $count = get_post_meta($post->ID,'total_sales', true); $text = sprintf( _n( '%s', '%s', $count, 'wpdocs_textdomain' ), number_format_i18n($count));echo $text;  ?>
				<?php endif; ?>
                 </div>
                <?php endif; ?>

                <div class="course-price">
                    <?php if ($vip_status): ?>
                        <span class="course-vip-price">
                                         <i class="fal fa-user-crown"></i>
                                        اعضای ویژه
                        </span>
                    <?php else: ?>
                        <?php woocommerce_template_loop_price(); ?>
                    <?php endif; ?>
               </div>

            </div>

        </div>

    </div>
</div>
