<?php
/**
Theme Designed By: Herowp
Email: keloncloud.com@gmail.com
Author Website: https://www.rtl-theme.com/user-profile/ah-ashrafi/
 */

get_header();

// Check if is default container
$is_vc_content = preg_match( "/\[vc_row.*?\]/i", $post->post_content );

// Password protected page doesn't use vc container
if ( post_password_required() ) {
	$is_vc_content = false;
}

// Container start
$site_inner = array('site-content-inner');
$container = array('main-page-content');

if ( $is_vc_content ) {
	$site_inner[] = 'vc-container';
} else {
	$site_inner[] = 'container';
	$container[] = 'default-margin';

} ?>

<div class="<?php echo esc_attr( implode( ' ', $container ) ); ?> default-margin" id="content">


	<div class="<?php echo esc_attr( implode( ' ', $site_inner ) ); ?>" role="main">

		<div class="page-container">
		<div class="page-main-content">

		<?php /* The loop */ ?>
		<?php while ( have_posts() ) : the_post(); ?>
			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

				<div class="entry-content">
					<?php the_content(); ?>
				</div>

				<?php keloncloud_wp_link_pages(); ?>

			</article><!-- #post -->

			<?php
                // If comments are open or we have at least one comment, load up the comment template.
                if ( comments_open() || get_comments_number() ) :
                    comments_template();
                endif;
			?>

		<?php endwhile; ?>
		</div>

		<?php get_sidebar( 'page' ); ?>
		</div>

	</div>



</div>

<?php get_footer(); ?>
