<?php
/**
Theme Designed By: Herowp
Email: keloncloud.com@gmail.com
Author Website: https://www.rtl-theme.com/user-profile/ah-ashrafi/
 */

get_header();

$blog_layout = 'list';
$blog_sidebar = 'right';
if ( class_exists('Redux') ) {
    $blog_sidebar = keloncloud_option('sidebar_position');
    $blog_layout = keloncloud_option('blog_post_style');
}

$sidebar_position = isset($_GET['sidebar']) ? $_GET['sidebar'] : $blog_sidebar;
$blog_container_classes = array('blog-archive');

if ( $sidebar_position == 'left' || $sidebar_position == 'right' ) {
    $blog_container_classes[] = 'has-sidebar';
}

if ( $sidebar_position == 'left' ) {
    $blog_container_classes[] = 'sidebar-left';
} elseif ( $sidebar_position == 'right' ) {
    $blog_container_classes[] = 'sidebar-right';
}

?>

<div class="main-page-content default-margin" id="content">
	<div class="site-content-inner container" role="main">
		<div class="<?php echo esc_attr( implode( ' ', $blog_container_classes ) ); ?>">
            <div class="blog-main-loop">
			<?php the_archive_description( '<div class="taxonomy-description">', '</div>' ); ?>
	            <?php
                    $blog_style = isset($_GET['blog_layout']) ? $_GET['blog_layout'] : $blog_layout;
                    get_template_part( '/inc/templates/blog/'.$blog_style );
	            ?>
            </div>

            <?php if ( $sidebar_position !== 'none' ) : ?>
                <aside class="main-sidebar-holder sticky-sidebar">
				<div class="theiaStickySidebar">
                    <?php get_sidebar(); ?>
				</div>
                </aside>
            <?php endif; ?>
        </div>
	</div>
</div>

<?php get_footer(); ?>

