<?php
/**
 * The Teacher Custom Post Type
 */

if ( !defined( 'ABSPATH' ) )
	die( '-1' );

if ( ! class_exists( 'Emperor_Teacher' ) && ! class_exists('WeDevs_Dokan') && ! is_plugin_active('tutor/tutor.php')) {

	class Emperor_Teacher {

		public static $instance;


		// Setup a single instance using the singleton pattern
		public static function init() {

			if ( is_null( self::$instance ) ) {
				self::$instance = new Emperor_Teacher();
			}
			return self::$instance;

		}

		function __construct() {

			add_action( 'init', array($this, 'register_post_type' ), 5 );
			add_action( 'cmb2_admin_init', array($this,'register_meta_boxes' ));

			if( is_admin() ) {

				add_filter( 'manage_edit-teacher_columns' , array( $this,'add_teacher_columns' ) );
				add_action( 'manage_teacher_posts_custom_column' , array( $this,'set_teacher_columns_content' ), 10, 2 );

			}
		}

		function register_post_type() {

			$options = get_option( 'dabir-teacher-options' );

			if ( post_type_exists( 'teacher' ) ) {
				return;
			}

			$labels = array(
				'name'                => _x( 'مدرسان', 'Post Type General Name', 'emperor' ),
				'singular_name'       => _x( 'مدرس', 'Post Type Singular Name', 'emperor' ),
				'menu_name'           => __( 'مدرسان', 'emperor' ),
				'parent_item_colon'   => __( 'مدرس والد:', 'emperor' ),
				'all_items'           => __( 'تمام مدرسان', 'emperor' ),
				'view_item'           => __( 'نمایش مدرس', 'emperor' ),
				'add_new_item'        => __( 'ایجاد مدرس جدید', 'emperor' ),
				'add_new'             => __( 'ایجاد', 'emperor' ),
				'edit_item'           => __( 'ویرایش مدرس', 'emperor' ),
				'update_item'         => __( 'آپدیت', 'emperor' ),
				'search_items'        => __( 'جستجو مدرس', 'emperor' ),
				'not_found'           => __( 'چیزی سافت نشد!', 'emperor' ),
				'not_found_in_trash'  => __( 'چیزی سافت نشد!', 'emperor' ),
			);

			$rewrite = array(
				'slug'                => $options['teacher-slug'],
				'with_front'          => false,
			);

			$args = array(
				'label'               => __( 'teacher', 'emperor' ),
				'description'         => __( 'Teacher Post Type', 'emperor' ),
				'labels'              => $labels,
				'supports'            => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
				'hierarchical'        => false,
				'public'              => true,
				'show_ui'             => true,
				'show_in_menu'        => true,
				'show_in_nav_menus'   => false,
				'show_in_admin_bar'   => true,
				'menu_position'       => 20,
				'can_export'          => true,
				'has_archive'         => true,
				'exclude_from_search' => false,
				'publicly_queryable'  => true,
				'query_var'           => true,
				'rewrite'             => $rewrite,
				'menu_icon'           => 'dashicons-awards',
				'capability_type'     => 'post',
			);

			register_post_type( 'teacher', $args );

		}

		function register_meta_boxes() {

			$prefix = '_keloncloud_';

			$teacher_metaboxes = new_cmb2_box( array(
				'id'           => 'teacher_metabox',
				'title'        => esc_html__( 'Teacher Details', 'emperor' ),
				'object_types' => array( 'teacher' ),
				'context'      => 'normal',
				'priority'     => 'high',
				'show_names'   => true,
			) );

			$teacher_metaboxes->add_field( array(
				'name' => esc_html__( 'Job Title', 'emperor' ),
				'default' => 'Senior Software Developer',
				'id'   => $prefix . 'teacher_job_title',
				'type' => 'text',
			) );

			$teacher_metaboxes->add_field( array(
				'name' => esc_html__( 'Facebook', 'emperor' ),
				'id' => 'facebook',
				'type' => 'text',
			) );

			$teacher_metaboxes->add_field( array(
				'name' => esc_html__( 'Twitter', 'emperor' ),
				'id' => 'twitter',
				'type' => 'text',
			) );

			$teacher_metaboxes->add_field( array(
				'name' => esc_html__( 'Google +', 'emperor' ),
				'id' => 'google-plus',
				'type' => 'text',
			) );

			$teacher_metaboxes->add_field( array(
				'name' => esc_html__( 'LinkedIn', 'emperor' ),
				'id' => 'linkedin',
				'type' => 'text',
			) );

			$teacher_metaboxes->add_field( array(
				'name' => esc_html__( 'Youtube', 'emperor' ),
				'id' => 'youtube-play',
				'type' => 'text',
			) );
		}

		function add_teacher_columns( $cols ) {

			$cols = array(
				'cb'        =>   '<input type="checkbox" />',
				'title'     => __( 'Title', 'emperor' ),
				'thumbnail' => __( 'Thumbnail', 'emperor')
			);

			return $cols;

		}

		function set_teacher_columns_content( $column, $post_id ) {

			$width = (int) 35;
			$height = (int) 35;

			switch( $column ) {

				case 'thumbnail' :
					$thumbnail_id = get_post_meta( $post_id, '_thumbnail_id', true );
					$attachments = get_children( array('post_parent' => $post_id, 'post_type' => 'attachment', 'post_mime_type' => 'image') );

					if ( $thumbnail_id ) {
						$thumb = wp_get_attachment_image( $thumbnail_id, array($width, $height), true );
					} elseif ( $attachments ) {
						foreach ( $attachments as $attachment_id => $attachment ) {
							$thumb = wp_get_attachment_image( $attachment_id, array($width, $height), true );
						}
					}

					if ( isset( $thumb ) && $thumb ) {
						echo wp_kses_post( $thumb );
					} else {
						echo __('None', 'educa-addons');
					}

					break;

			}

		}

	}

    Emperor_Teacher::init();
}