<?php

# Library
require_once get_parent_theme_file_path('/inc/tgm/class-tgm-plugin-activation.php');

add_action( 'tgmpa_register', 'keloncloud_register_required_plugins' );

function keloncloud_register_required_plugins( $return = false ) {

	$plugins = array(

		array(
			'name'               => esc_html__( 'WooCommerce', 'emperor' ),
			'slug'               => 'woocommerce',
			'required'           => true,
		),
		array(
			'name'      => esc_html__( 'افزونه فونت امپراطور', 'emperor' ),
			'slug'      => 'emperor-fonts',
			'source'    => get_template_directory() . '/inc/lib/plugins/emperor-fonts.zip',
			'required'  => true,
			'version'  				=> '1.0',
		),

		array(
			'name'      => esc_html__( 'CMB2', 'emperor' ),
			'slug'      => 'cmb2',
			'required'  => true,
		),

		array(
			'name'     => esc_html__( 'Breadcrumb NavXT', 'emperor' ),
			'slug'     => 'breadcrumb-navxt',
			'required' => true
		),

		array(
			'name'      => esc_html__( 'MailChimp for WordPress', 'emperor' ),
			'slug'      => 'mailchimp-for-wp',
			'required'  => false,
		),
        array(
            'name'      => esc_html__( 'Parsidate for WordPress', 'emperor' ),
            'slug'      => 'wp-parsidate',
            'required'  => false,
        ),

		array(
			'name'        => esc_html__( 'Portfolio Post Type', 'emperor' ),
			'slug'        => 'portfolio-post-type',
			'required'    => false,
		),
		array(
			'name'        => esc_html__( 'کیف پول', 'emperor' ),
			'slug'        => 'woo-wallet',
			'required'    => false,
		),


		array(
			'name'        => esc_html__( 'علاقه مندی', 'emperor' ),
			'slug'        => 'yith-woocommerce-wishlist',
			'required'    => true,
		),

	);

	if($return) {
		return $plugins;
	} else {
		$config = array(
			'is_automatic' => true
		);

		tgmpa($plugins, $config);
	}
}
