<?php
/**
 * Template for top bar header
 */


$topbar_left_text = '';
$topbar_display_opt = true;
$topbar_color = 'light';
$top_bar_phone = '';
$top_bar_email = '';
$cart_icon = true;
$pup_up_button = true;

if ( class_exists('Redux') ) {
	$topbar_left_text = keloncloud_option( 'topbar_text' );
	$topbar_display_opt = keloncloud_option( 'topbar_display_opt' );
	$topbar_color = keloncloud_option( 'topbar_color' );
	$header_button = keloncloud_option('header_button');
	$header_button_link = keloncloud_option('header_button_link');
	$header_button_custom_link = keloncloud_option('header_button_custom_link');
	$header_button_custom_text = keloncloud_option('header_button_custom_text');
	$cart_icon = keloncloud_option('topbar_cart');
	$pup_up_button = keloncloud_option('pup_up_button');

}

$menu = wp_nav_menu(
    array(
        'theme_location'    => 'top-bar-menu',
        'container'         => 'nav',
        'menu_class'        => 'top-menu',
        'echo'				=> false
    )
);

?>
<?php if ( $topbar_display_opt ) :?>
<div class="top-bar">
    <div class="container">
        <div class="row">
            <div class="top-bar-col">
                <?php if ( has_nav_menu('top-bar-menu') ) : ?>
                    <div class="top-bar-secondary-menu">
                        <?php echo wp_kses_post($menu); ?>
                    </div>
                <?php endif; ?>
            </div>
            <div class="top-bar-col">
                <?php get_template_part( 'inc/templates/header/top-bar-links' ); ?>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
