<?php
/**
 * The template for displaying top bar links like search, shop cart & secondary menu
 */

$search_icon = true;
$cart_icon = true;

if ( class_exists( 'Redux' ) ) {
    $top_bar_phone = keloncloud_option( 'top_bar_phone' );
    $top_bar_email = keloncloud_option( 'top_bar_email' );
}

?>
<div class="top-bar-links">

    <?php if ( $top_bar_phone || $top_bar_email ) : ?>
        <ul class="top-bar-contact-info">
            <?php if( $top_bar_phone ){ ?>
                <li><a href="tel:<?php echo esc_html( $top_bar_phone ); ?>"><?php echo esc_html( $top_bar_phone ); ?><i class="fal fa-phone-square"></i></a></li>
            <?php } ?>
            <?php if( $top_bar_email ){ ?>
                <li><a href="mailto:<?php echo esc_html( $top_bar_email ); ?>"> <i class="fal fa-envelope"></i><?php echo esc_html( $top_bar_email ); ?> </a></li>
            <?php } ?>
        </ul>
    <?php endif; ?>


</div>
