<?php
/**
 * The template for displaying inner content on single posts
 */

$separate_meta = esc_html__( ', ', 'emperor' );

// Get Categories for posts.
$categories_list = get_the_category_list( $separate_meta );

// Get Tags for posts.
$tags_list = get_the_tag_list( '' );

$blog_post_share = false;
$article_author = true;
$blog_related = true;
$blog_featured_img = true;

if ( class_exists('Redux') ) {
	$blog_post_share = keloncloud_option('blog_share_story');
	$article_author = keloncloud_option('article_author');
	$blog_share_story = keloncloud_option('blog_share_story');
	$blog_related = keloncloud_option('blog_related');
	$blog_meta_data = keloncloud_option('blog_meta_data');
	$report_form = keloncloud_option('report_form');
	$related_blog_layout = keloncloud_option('related-blog_post_style');
}
$prefix = '_keloncloud_';
$audio_post_id = get_post_meta(get_the_ID(), $prefix . 'audio_post_id', true);
$download_box_content = get_post_meta(get_the_ID(), $prefix . 'download_box_content', true);
$download_box_password = get_post_meta(get_the_ID(), $prefix . 'download_box_password', true);
$download_login = get_post_meta(get_the_ID(), $prefix . 'download_login', true);

$related_blog_layout = keloncloud_option('related-blog_post_style');

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> role="article">
	<?php while ( have_posts() ) : the_post(); ?>

		<div class="post-inner">

			<header class="entry-header">
			<?php the_title('<h1 class="entry-title">', '</h1>'); ?>
			<?php if ( $blog_meta_data ) : ?>
				<?php get_template_part( '/inc/templates/blog/blog-meta-data' ); ?>
			<?php endif; ?>

			</header>

			<?php if ( $blog_featured_img ) : ?>
			<?php if ( has_post_thumbnail() ) : ?>
				<div class="post-thumbnail">
					<?php echo the_post_thumbnail( 'full' ); ?>
				</div>
			<?php endif; ?>
			<?php endif; ?>

			<div class="audio_box">
				<?php
					$attr =  array(
						'mp3'      => $audio_post_id,
					);
					echo wp_audio_shortcode(  $attr );
				?>
			</div>

			<div class="entry-content">
				<?php the_content(); ?>
				<?php wp_link_pages(array(
					'before' => '<div class="page-pagination"><div class="page-links-title">' . esc_html__('Pages:', 'emperor') . '</div>',
					'after' => '</div>',
					'link_before' => '<span>', 'link_after' => '</span>'
				)); ?>
			</div>



			<?php if ( $blog_share_story ) : ?>
				<?php
					get_template_part( '/inc/templates/sharing-blog' );
				?>
			<?php endif; ?>



		</div>


		<?php if ( !empty($download_box_content) ) : ?>
		<div class="post-inner">



			<?php if ( !empty($download_box_content) ) : ?>
				<div class="help_download">
					<?php echo ($download_box_content); ?>
				</div>
			<?php endif; ?>

            <div class="box_download">

                <span><i class="far fa-link"></i> دانلود فایل </span>
                <div class="box_content">
                    <?php if (is_user_logged_in()) : ?>
                        <?php get_template_part('/inc/templates/blog/download-links'); ?>
                    <?php elseif ($download_login) : ?>
                        <p class="msg-box-download">برای دسترسی به لینک های دانلود وارد حساب کابری خود شوید.</p>
                        <a href="#" class="register-modal-opener login-box-download-btn"><i
                                    class="fal fa-user-lock"></i>ورود به حساب</a>
                    <?php else: ?>
                        <?php get_template_part('/inc/templates/blog/download-links'); ?>
                    <?php endif; ?>
                </div>
            </div>

			<p class="button_download">
                <a class="link-not" type="button" data-toggle="collapse" data-target="#report" aria-expanded="false" aria-controls="report">گزارش خرابی لینک</a>
  			<span class="password" id="password" data-toggle="tooltip" data-placement="top" title="" data-original-title="جهت کپی پسورد کلیک کنید">پسورد فایل : <em id="password_copy"><?php echo ($download_box_password); ?></em></span>
  		</p>

			<div class="collapse">
    		<div class="well">
				<?php echo do_shortcode ($report_form); ?>
				</div>
			</div>

		</div>
		<?php endif; ?>

		<?php if ( $tags_list && ! is_wp_error( $tags_list ) ) : ?>
		<div class="post-inner">

					<div class="post-tags">
						<span><i class="fal fa-tags"></i><?php esc_html_e( 'Tags:', 'emperor' ); ?></span>
						<?php echo wp_kses_post( $tags_list ); ?>
					</div>
		</div>
		<?php endif; ?>



		<?php if ( $article_author == '1' && get_the_author_meta( 'description') !== '' ) : ?>
		<div class="post-inner">
                <div class="post-author-box">
					<?php
					$author_bio_avatar_size = apply_filters( 'goseowp_author_bio_avatar_size', 130 );

					echo get_avatar( get_the_author_meta( 'user_email' ), $author_bio_avatar_size );
					?>
                    <div class="author-content">
                        <h5 class="author-title"><?php printf( esc_html__( 'About %s', 'emperor' ), get_the_author() ); ?></h5>
                        <p class="author-bio">
							<?php the_author_meta( 'description' ); ?>
                        </p>
                        <a class="author-link btn btn-border btn-small" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
                            <?php printf(esc_html__('سایر نوشته های  %s', 'emperor'), get_the_author()); ?>
                        </a>
                    </div>
                </div>
				</div>
            <?php endif; ?>

			<?php dynamic_sidebar('single_blog_ads'); ?>

			<?php if ( $blog_related ) : ?>

			<?php
						$related_blog_style = isset($_GET['related_blog_layout']) ? $_GET['related_blog_layout'] : $related_blog_layout;
						get_template_part( '/inc/templates/blog/'.$related_blog_style );
			?>
			<?php endif; ?>

			<?php $related_product_post = new WP_Query(
							array(
								'post_type' => 'product',
								'posts_per_page' => 5,
								'product_cat' => $product_cats
							));
			?>

<?php if ( !empty($product_cats) ) : ?>
		<div class="product-reviews">
				<div class="product-review-title">
          <i class="fal fa-user-graduate"></i>  <h3 class="inner">دوره های آموزشی مرتبط</h3>
        </div>
				<div class="product-reviews-inner">

					<div class="products courses-holder">
						<div class="owl-carousel" data-autoplay="false" data-slider-items="3" data-pagination="true" data-navigation="true" data-loop="false">
							<?php while ( $related_product_post->have_posts() ) : $related_product_post->the_post(); ?>
								<?php get_template_part( 'woocommerce/content', 'product-carousel' ); ?>
							<?php endwhile; // end of the loop.

							wp_reset_postdata();

							 ?>

						</div>
					</div>

				</div>
    </div>
<?php endif; ?>

	<?php endwhile; ?>
</article>
