<?php

$blog_grid_columns = 'two';
$blog_desc_text = false;
$blog_cate = false;

if (class_exists('Redux')) {
    $blog_grid_columns = keloncloud_option('blog_grid_columns');
    $blog_thumbnails_size = keloncloud_option('blog_thumbnails_size');
    $blog_desc_text = keloncloud_option('blog_desc_text');
    $blog_cate = keloncloud_option('blog_cate');
}

$categories = get_the_category();

?>
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="modern-post-inner">
        <div class="modern-post-shadow"></div>
        <div><a href="<?php the_permalink(); ?>" class="post-link">
                <?php if (has_post_thumbnail()) : ?>
                    <figure class="post-thumb"><?php the_post_thumbnail( 'metro_others' ); ?></figure>
                <?php endif; ?>
            </a>
            <?php if ($blog_cate) : ?>
                <div class="post-path"><span><?php print get_the_category(get_the_ID())[0]->name; ?></span>
                </div>
            <?php endif; ?>
        </div>

        <div class="post-content"><a href="<?php the_permalink(); ?>"><h2><?php the_title(); ?></h2></a>
            <?php if ($blog_desc_text) : ?>
            <div class="post-description">
                <?php
                if (has_excerpt()) {
                    $content = the_excerpt();
                } else {
                    echo wp_trim_words(get_the_content(), 15, '...');
                }
                ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
