<?php

$blog_grid_columns = 'two';
$blog_desc_text = false;
$blog_cate = false;

if ( class_exists('Redux') ) {
	$blog_grid_columns = keloncloud_option('blog_grid_columns');
	$blog_thumbnails_size = keloncloud_option('blog_thumbnails_size');
	$blog_desc_text = keloncloud_option('blog_desc_text');
    $blog_cate = keloncloud_option('blog_cate');
}

$categories = get_the_category();
$prefix = '_keloncloud_';
$audio_post_id = get_post_meta(get_the_ID(), $prefix . 'audio_post_id', true);

?>
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="post-inner audio-inner">
		<?php if ( has_post_thumbnail() ) : ?>
			<div class="post-thumbnail">
				<a href="<?php the_permalink(); ?>" class="audio-icon">
				<i class="fal fa-microphone-alt"></i>

				<?php if ( $blog_thumbnails_size == 'square' ) : ?>
					<?php the_post_thumbnail('keloncloud-image-400x400-croped'); ?>
				<?php elseif ( $blog_thumbnails_size == 'rectangle' ) : ?>
					<?php the_post_thumbnail('keloncloud-image-420x294-croped'); ?>
				<?php endif; ?>

				</a>
			</div>
		<?php endif; ?>


		<div class="post-content">

            <div class="post-entry">
                <?php if ($blog_cate) : ?>
                    <span class="category"><?php print get_the_category(get_the_ID())[0]->name; ?></span>
                <?php endif; ?>
                <h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
            </div>
			<?php if ( $blog_desc_text ) : ?>
				<div class="the-excerpt gird-excerpt">
					<?php
						if( has_excerpt() ){
        			$content = the_excerpt();
    				} else {
      				echo wp_trim_words( get_the_content(), 15, '...' );
    				}
				 ?>
				</div>
			<?php endif; ?>
            <div class="more-holder">
                <a href="<?php the_permalink(); ?>">گوش کنید</a>
            </div>
		</div>
		<div class="clearfix"></div>
	</div>
</div>
