<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class keloncloud_Widget_Testimonials extends Widget_Base {

    public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);

        global $theme_version;
        $theme_obj     = wp_get_theme();
        $theme_version = $theme_obj->get( 'Version' );

        wp_register_script( 'emperor-testimonials-handle', get_theme_file_uri( 'assets/js/elementor/testimonials.js' ) , [ 'elementor-frontend' ], $theme_version, true );
    }

   public function get_name() {
      return 'testimonials';
   }

   public function get_title() {
      return esc_html__( 'نظرات کاربران', 'emperor' );
   }

   public function get_icon() {
        return 'eicon-testimonial';
   }

   public function get_categories() {
      return [ 'emperor-elements' ];
   }

   protected function _register_controls() {

      $this->start_controls_section(
         'testimonials_section',
         [
            'label' => esc_html__( 'Testimonials', 'emperor' ),
            'type' => Controls_Manager::SECTION,
         ]
      );

      $repeater = new \Elementor\Repeater();

      $repeater->add_control(
         'image',
         [
            'label' => __( 'Choose Photo', 'emperor' ),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
               'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
         ]
      );

      $repeater->add_control(
         'name',
         [
            'label' => __( 'Name', 'emperor' ),
            'type' => \Elementor\Controls_Manager::TEXT,

         ]
      );

      $repeater->add_control(
         'designation',
         [
            'label' => __( 'Designation', 'emperor' ),
            'type' => \Elementor\Controls_Manager::TEXT
         ]
      );

      $repeater->add_control(
         'testimonial',
         [
            'label' => __( 'Testimonial', 'emperor' ),
            'type' => \Elementor\Controls_Manager::TEXTAREA
         ]
      );

      $repeater->add_control(
         'video',
         [
            'label' => __( 'ویدئوی نظر مشتری', 'emperor' ),
            'type' => \Elementor\Controls_Manager::URL
         ]
      );

      $this->add_control(
         'testimonial_list',
         [
            'label' => __( 'Testimonial List', 'emperor' ),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'title_field' => '{{{name}}}',

         ]
      );

      $this->end_controls_section();


      $this->start_controls_section(
         'testimonials__carousel_section',
         [
            'label' => esc_html__( 'تنظیمات کروسل', 'emperor' ),
            'type' => Controls_Manager::SECTION,
         ]
      );


      $this->add_control(
           'pagination',
           [
              'label' => __( 'صفحه گذاری اسلایدر', 'emperor' ),
              'type' => \Elementor\Controls_Manager::SWITCHER,
              'default' => 'yes',

           ]
        );

  	  $this->add_control(
           'navigation',
           [
              'label' => __( 'فلش های ناوبری', 'emperor' ),
              'type' => \Elementor\Controls_Manager::SWITCHER,
              'default' => 'yes',

           ]
        );

  	  $this->add_control(
           'loop',
           [
              'label' => __( 'حلقه کروسل', 'emperor' ),
              'type' => \Elementor\Controls_Manager::SWITCHER,
              'default' => 'yes',

           ]
        );

  	  $this->add_control(
           'autoplay',
           [
              'label' => __( 'اجرای خودکار اسلایدر', 'emperor' ),
              'type' => \Elementor\Controls_Manager::SWITCHER,
              'default' => 'yes',

           ]
        );


      $this->end_controls_section();


   }

   protected function render( $instance = [] ) {
       
      $settings = $this->get_settings_for_display();
      $slider_data = array();
      $slider_data['data-slider-items'] = $settings['columns'];
      $slider_data['data-loop'] = $settings['loop'];
      $slider_data['data-pagination'] = $settings['pagination'];
      $slider_data['data-navigation'] = $settings['navigation'];
      
      ?>

      <div class="testimonials-wrapper testimonials-row align-items-center">

            <div class="testimonials-carousel owl-carousel" <?php echo keloncloud_get_inline_attrs( $slider_data ); ?>>
              <?php foreach (  $settings['testimonial_list'] as $testimonial_single ): ?>
                <div class="keloncloud-testimonial-item">
                <div class="keloncloud-ts-inner">
                    <div class="testimonial-author">
                        <div class="keloncloud-testimonial-avatar">
                            <img src="<?php echo esc_url( $testimonial_single['image']['url'] ); ?>" alt="<?php echo esc_html($testimonial_single['name']); ?>">
                        </div>

                        <div class="keloncloud-testimonial-author-main">
                            <h5 class="keloncloud-testimonial-author-name"><?php echo esc_html($testimonial_single['name']); ?></h5>
                            <span class="keloncloud-testimonial-author-role"><?php echo esc_html($testimonial_single['designation']); ?></span>
                        </div>

                        <div class="testimonial-author-video">
                            <a class="keloncloud-testimonial-video" href="<?php echo esc_url($testimonial_single['video']['url']); ?>"> <i class="fal fa-play"></i>
                                <p>مشاهده ویدئو</p>
                            </a>
                        </div>
                    </div>
		                 <div class="testimonial-content">
			                    <blockquote>
				                        <?php echo esc_html($testimonial_single['testimonial']); ?>
						              </blockquote>
		                 </div>
	            </div>
              </div>
              <?php endforeach; ?>
            </div>
      </div>
   <?php }

    public function get_script_depends() {
        return [ 'keloncloud-theme', 'emperor-testimonials-handle' ];
    }
}

Plugin::instance()->widgets_manager->register_widget_type( new keloncloud_Widget_Testimonials );
