<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

class keloncloud_Widget_Testimonials_Swiper extends Widget_Base
{

    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);

        global $theme_version;
        $theme_obj = wp_get_theme();
        $theme_version = $theme_obj->get('Version');

        wp_register_style('emperor-testimonials-swiper-css', get_theme_file_uri('assets/css/swiper.min.css'));
        wp_register_script('emperor-testimonials-swiper-js', get_theme_file_uri('assets/js/vendor/swiper.min.js'), ['elementor-frontend'], $theme_version, true);
        wp_register_script('emperor-testimonials-swiper-swiper-js', get_theme_file_uri('assets/js/elementor/testimonials-swiper.js'), ['elementor-frontend'], $theme_version, true);
    }


    public function get_name()
    {
        return 'testimonials_swiper';
    }

    public function get_title()
    {
        return esc_html__('نظرات کاربران کارتی', 'emperor');
    }

    public function get_icon()
    {
        return 'eicon-testimonial';
    }

    public function get_categories()
    {
        return ['emperor-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'testimonials_section',
            [
                'label' => esc_html__('Testimonials', 'emperor'),
                'type' => Controls_Manager::SECTION,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => __('Choose Photo', 'emperor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'name',
            [
                'label' => __('Name', 'emperor'),
                'type' => \Elementor\Controls_Manager::TEXT,

            ]
        );

        $repeater->add_control(
            'designation',
            [
                'label' => __('Designation', 'emperor'),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $repeater->add_control(
            'testimonial',
            [
                'label' => __('Testimonial', 'emperor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA
            ]
        );


        $this->add_control(
            'testimonial_list',
            [
                'label' => __('Testimonial List', 'emperor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{name}}}',

            ]
        );

        $this->end_controls_section();

    }

    protected function render($instance = [])
    {

        // get our input from the widget settings.
        $settings = $this->get_settings_for_display();

        ?>

        <div class="swiper ts-swiper">
            <div class="swiper-wrapper">
                <?php foreach ($settings['testimonial_list'] as $testimonial): ?>
                    <div class="swiper-slide ts-swiper-item d-flex flex-column justify-content-center align-items-center">
                        <p class="desc text-center"><?php echo $testimonial['testimonial'] ?></p>
                        <div class="d-flex align-items-center mt-3">
                            <img src="<?php echo $testimonial['image']['url'] ?>" alt="">
                            <div>
                                <p class="name"><?php echo $testimonial['name'] ?></p>
                                <p class="sub mb-0"><?php echo $testimonial['designation'] ?></p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <?php
    }

    public function get_style_depends()
    {

        return ['emperor-main', 'emperor-testimonials-swiper-css'];

    }

    public function get_script_depends()
    {
        return ['keloncloud-theme', 'emperor-testimonials-swiper-js', 'emperor-testimonials-swiper-swiper-js'];
    }

}

Plugin::instance()->widgets_manager->register_widget_type(new keloncloud_Widget_Testimonials_Swiper);
