<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

class keloncloud_Widget_special extends Widget_Base
{
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);

        global $theme_version;
        $theme_obj = wp_get_theme();
        $theme_version = $theme_obj->get('Version');

        wp_register_script('emperor-special-offer-handle', get_theme_file_uri('assets/js/elementor/special-offer.js'), ['elementor-frontend'], $theme_version, true);
    }


    public function get_name()
    {
        return 'special-offer';
    }

    public function get_title()
    {
        return __('اسلایدر شگفت انگیز', 'filato');
    }

    public function get_icon()
    {
        return 'fal fa-star';
    }

    public function get_categories()
    {
        return ['emperor-elements'];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'section_title',
            [
                'label' => __('اسلایدر شگفت انگیز', 'filato'),
            ]
        );


        $this->add_control(
            'show_dis',
            [
                'label' => __('فقط محصولات تخفیف خورده نمایش داده شود', 'filato'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('On', 'filato'),
                'label_off' => __('Off', 'filato'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'out_stock',
            [
                'label' => __('متن تمام شدن محصول در انبار', 'filato'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'placeholder' => __('ظرفیت تکمیل شد', 'filato'),
                'default' => __('ظرفیت تکمیل شد', 'filato'),
            ]
        );

        $this->add_control(
            'out_icon',
            [
                'label' => __('نمایش آیکون اتمام موجودی', 'filato'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('On', 'filato'),
                'label_off' => __('Off', 'filato'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'auto_play',
            [
                'label' => __('حرکت خودکار', 'filato'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('On', 'filato'),
                'label_off' => __('Off', 'filato'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'time',
            [
                'label' => __('سرعت حرکت خودکار (میلی ثانیه)', 'filato'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1000,
                'max' => 20000,
                'step' => 1000,
                'default' => 8000,
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();

        ?>

        <div class="position-relative special-main-box">
            <div class="row special-box">
                <?php

                $args = array(
                    'posts_per_page' => 5,
                    'post_type' => 'product',
                    'post_status' => 'publish',
                    'meta_query' => array(
                        'relation' => 'AND',
                        array(
                            'key' => '_keloncloud_special',
                            'value' => 'on',
                            'compare' => '='
                        )
                    ),
                    'order' => 'DESC');

                if ('yes' === $settings['show_dis']) {
                    $args['post__in'] = array_merge(array(0), wc_get_product_ids_on_sale());
                }

                $specialpost = new \WP_Query($args);

                if ($specialpost->have_posts()) { ?>
                    <div class="col-lg-8 col-12">
                        <div class="owl-carousel special-slider" <?php if ('yes' === $settings['auto_play']) {
                            echo 'data-itemplay="true"';
                        } else {
                            echo 'data-itemplay="false"';
                        } ?> data-itemtime="<?php echo $settings['time']; ?>">
                            <?php while ($specialpost->have_posts()) : $specialpost->the_post();
                                $product = wc_get_product(get_the_ID());

                                if ($product->is_type('variable')) {
                                    $r_price = $product->get_variation_regular_price('min') . get_woocommerce_currency_symbol();
                                    $s_price = $product->get_variation_sale_price('min') . get_woocommerce_currency_symbol();
                                } else {
                                    $r_price = $product->get_regular_price() . get_woocommerce_currency_symbol();
                                    $s_price = $product->get_sale_price() . get_woocommerce_currency_symbol();
                                }
                                ?>
                                <?php $stockq = $product->get_stock_quantity(); ?>
                                <div class="row item pt-4 pt-md-0">
                                    <?php if ($stockq === 0) { ?>
                                        <div class="pnot-in-stock">
                            <span class="not-stock-text">
                                <?php if ('yes' === $settings['out_icon']) { ?>
                                    <i class="fal fa-frown" aria-hidden="true"></i>
                                <?php } ?>
                                <?php echo $settings['out_stock']; ?>
                            </span>
                                        </div>
                                    <?php } ?>
                                    <?php if ($stockq === 0) { ?>
                                    <div class="pblur">
                                        <?php } ?>
                                        <div class="col-md-5 special-img position-relative">

                                            <?php
                                            if ($product->is_on_sale()) { ?>
                                                <?php

                                                if ($product->is_on_sale()) {

                                                    if (!$product->is_type('variable')) {

                                                        $max_percentage = (($product->get_regular_price() - $product->get_sale_price()) / $product->get_regular_price()) * 100;

                                                    } else {

                                                        $max_percentage = 0;

                                                        foreach ($product->get_children() as $child_id) {
                                                            $variation = wc_get_product($child_id);
                                                            $price = $variation->get_regular_price();
                                                            $sale = $variation->get_sale_price();
                                                            if ($price != 0 && !empty($sale)) $percentage = ($price - $sale) / $price * 100;
                                                            if ($percentage > $max_percentage) {
                                                                $max_percentage = $percentage;
                                                            }
                                                        }

                                                    }
                                                    echo "<div class='sale-perc-badge'>";
                                                    echo "<div class='sale-perc'>" . round($max_percentage) . "% </div>";
                                                    echo "<div class='sale-badge-text'>تخفیف</div>";
                                                    echo "</div>";
                                                }
                                                ?>
                                            <?php }
                                            ?>

                                            <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                                                <?php woocommerce_template_loop_product_thumbnail(); ?>
                                            </a>
                                        </div>
                                        <div class="col-md-7 special-text my-4">
                                            <div class="col-12 sp-custom-title">
                                                <a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a>
                                            </div>

                                            <div class="col-12 sp-rate">
                                                <?php
                                                $rating_count = $product->get_rating_count();
                                                $average = $product->get_average_rating();
                                                $average_number = $average;
                                                $class = null;

                                                $vote_title = sprintf(esc_html__('%s Votes', 'filato'), $rating_count);

                                                if ($rating_count > 0) {
                                                    $title = sprintf(esc_html__('Rated %s out of 5', 'filato'), $average);
                                                    $class = 'has-ratings';
                                                } else {
                                                    $title = esc_html__('Not yet rated', 'filato');
                                                    $average = esc_html__('No Votes', 'filato');
                                                    $class = 'no-ratings';
                                                }
                                                ?>

                                                <?php if (get_option('woocommerce_enable_review_rating') != 'no'): ?>
                                                    <div class="rate d-flex align-items-center justify-content-between mb-3">
                                                        <div class="average-rating-number"><span
                                                                    class="title-rate">امتیاز</span>
                                                            <div class="schema-stars">
                               <span><?php $average = $product->get_average_rating();
                                   echo esc_attr($average); ?></span>
                                                                <span class="title-rate">از</span>
                                                                <span><?php $rating_count = $product->get_rating_count();
                                                                    echo esc_attr($rating_count); ?></span>
                                                                <span class="title-rate">رأی</span>
                                                            </div>
                                                        </div>
                                                        <div class="average-rating-stars">
                                                            <div class="star-rating <?php echo esc_attr($class); ?>"
                                                                 title="<?php echo esc_attr($title); ?>">
	                        <span style="width:<?php echo(($average_number / 5) * 100); ?>%">
		                         <span class="rating"><?php echo esc_html($average); ?></span>
		                        <span class="votes-number"><?php echo esc_html($vote_title); ?></span>
	                        </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            </div>

                                            <div class="col-12 sp-price my-4">
                                                <?php if ($product->is_on_sale()) { ?>
                                                    <span class="sp-rprice"><del><?php echo wc_price($r_price); ?></del></span>
                                                    <span class="sp-sprice"><?php echo wc_price($s_price); ?></span>
                                                <?php } else { ?>
                                                    <span class="sp-sprice"><?php echo wc_price($r_price); ?></span>
                                                <?php } ?>
                                            </div>

                                            <?php
                                            if ($product->is_type('variable')) {
                                                $children_ids = $product->get_children();
                                                $children_id = $children_ids[0];
                                                $date = get_post_meta($children_id, '_sale_price_dates_to', true);
                                            } else {
                                                $date = get_post_meta(get_the_ID(), '_sale_price_dates_to', true);
                                            }
                                            if (!empty($date)) {
                                                $date += 24 * 60 * 60;
                                                $sale_price_date = ($date) ? date('Y/m/d', $date) : '';
                                                $date_diff = ($date) ? date('Y-m-d', $date) : '';
                                                $now = time(); // or your date as well
                                                $your_date = strtotime($date_diff);
                                                $diff = $your_date - $now;
                                                $datediff = round($diff / (60 * 60 * 24)); ?>
                                                <?php if ($product->is_on_sale()) { ?>
                                                    <div class="col-12">
                                                        <div class="salecount" data-datediff="<?php echo $datediff; ?>"
                                                             data-countdown="<?php echo $sale_price_date; ?>"
                                                             data-dir="<?php echo (is_rtl()) ? 'rtl' : 'ltr'; ?>"
                                                             data-seconds="ثانیه" data-minutes="دقیقه" data-hours="ساعت"
                                                             data-days="روز" data-weeks="هفته"></div>
                                                    </div>
                                                <?php } ?>
                                            <?php } ?>
                                        </div>
                                        <?php if ($stockq === 0) { ?>
                                    </div>
                                <?php } ?>
                                </div>
                            <?php endwhile; ?>
                        </div>
                    </div>

                    <div class="col-lg-4 d-none d-lg-block special-title">
                        <ul id="slider-nav">
                            <?php while ($specialpost->have_posts()) : $specialpost->the_post(); ?>
                                <?php $product = wc_get_product(get_the_ID()); ?>

                                <li>
                                    <?php if ($product->is_on_sale()) { ?>
                                        <?php

                                        if ($product->is_on_sale()) {

                                            if (!$product->is_type('variable')) {

                                                $max_percentage = (($product->get_regular_price() - $product->get_sale_price()) / $product->get_regular_price()) * 100;

                                            } else {

                                                $max_percentage = 0;

                                                foreach ($product->get_children() as $child_id) {
                                                    $variation = wc_get_product($child_id);
                                                    $price = $variation->get_regular_price();
                                                    $sale = $variation->get_sale_price();
                                                    if ($price != 0 && !empty($sale)) $percentage = ($price - $sale) / $price * 100;
                                                    if ($percentage > $max_percentage) {
                                                        $max_percentage = $percentage;
                                                    }
                                                }

                                            }
                                            echo "<div class='perc-badge'>" . round($max_percentage) . "%" . "</div>";
                                        }
                                        ?>
                                    <?php } ?>
                                    <?php woocommerce_template_loop_product_thumbnail(); ?>
                                    <span><?php the_title(); ?></span>
                                </li>
                            <?php endwhile; ?>
                            <?php wp_reset_postdata(); ?>
                        </ul>
                    </div>
                <?php } else {
                    echo '<div class="col-12 not-msg">' . __('محصولی با شروط تعریف شده پیدا نشد!', 'filato') . '</div>';
                } ?>
            </div>
        </div>
        <?php

    }

    public function get_script_depends()
    {
        return ['keloncloud-theme', 'emperor-special-offer-handle'];
    }

}

Plugin::instance()->widgets_manager->register_widget_type(new keloncloud_Widget_special);