<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class keloncloud_Widget_Simple_Slider extends Widget_Base {

    public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);

        global $theme_version;
        $theme_obj     = wp_get_theme();
        $theme_version = $theme_obj->get( 'Version' );

        wp_register_script( 'emperor-slider-handle', get_theme_file_uri( 'assets/js/elementor/slider.js' ) , [ 'elementor-frontend' ], $theme_version, true );
    }


    public function get_name() {
      return 'slider';
   }

   public function get_title() {
      return esc_html__( 'اسلایدر', 'emperor' );
   }

   public function get_icon() {
        return 'eicon-slides';
   }

   public function get_categories() {
      return [ 'emperor-elements' ];
   }
   protected function _register_controls() {
      $this->start_controls_section(
         'slider_section',
         [
            'label' => esc_html__( 'اسلایدر', 'emperor' ),
            'type' => Controls_Manager::SECTION,
         ]
      );

       $slider = new Repeater();


       $slider->add_control(
           'slide_title', [
               'label' => __( 'عنوان اسلاید', 'emperor' ),
               'type' => Controls_Manager::TEXT,
               'label_block' => true,
           ]
       );

       $slider->add_control(
           'slide_link',
           [
               'label' => __( 'لینک اسلاید', 'emperor' ),
               'type' => Controls_Manager::URL,
               'placeholder' => __( 'https://your-link.com', 'emperor' ),
               'show_external' => true,
               'default' => [
                   'url' => '#',
                   'is_external' => true,
                   'nofollow' => true,
               ],
           ]
       );

       $slider->add_control(
           'slide_image',
           [
               'label' => __( 'انتخاب تصویر', 'emperor' ),
               'type' => Controls_Manager::MEDIA,
               'default' => [
                   'url' => Utils::get_placeholder_image_src(),
               ],
           ]
       );

       $this->add_control(
           'slides',
           [
               'label' => __( 'اسلایدر', 'emperor' ),
               'type' => Controls_Manager::REPEATER,
               'fields' => $slider->get_controls(),
               'default' => [
                   [
                       'slide_title' => __( 'عنوان اسلاید', 'emperor' ),
                       'slide_link' => __( 'https://your-link.com', 'emperor' ),
                   ],
               ],
               'title_field' => '{{{ slide_title }}}',
           ]
       );

       $this->add_control(
           'show_arrows',
           [
               'label' => __( 'نمایش جهت ها', 'emperor' ),
               'type' => Controls_Manager::SWITCHER,
               'label_on' => __( 'بله', 'emperor' ),
               'label_off' => __( 'خیر', 'emperor' ),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
       );

       $this->add_control(
           'auto_play',
           [
               'label' => __( 'چرخش خودکار', 'emperor' ),
               'type' => Controls_Manager::SWITCHER,
               'label_on' => __( 'بله', 'emperor' ),
               'label_off' => __( 'خیر', 'emperor' ),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
       );

       $this->add_control(
           'time',
           [
               'label' => __( 'سرعت چرخش(ms)', 'emperor' ),
               'type' => Controls_Manager::NUMBER,
               'min' => 1000,
               'max' => 20000,
               'step' => 1000,
               'default' => 8000,
           ]
       );

       $this->add_control(
           'show_dots',
           [
               'label' => __( 'نمایش دکمه ها پیمایش', 'emperor' ),
               'type' => Controls_Manager::SWITCHER,
               'label_on' => __( 'بله', 'emperor' ),
               'label_off' => __( 'خیر', 'emperor' ),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
       );

       $this->add_control(
           'pause_over',
           [
               'label' => __( 'توقف چرخش هنگام قرارگیری ماوس', 'emperor' ),
               'type' => Controls_Manager::SWITCHER,
               'label_on' => __( 'بله', 'emperor' ),
               'label_off' => __( 'خیر', 'emperor' ),
               'return_value' => 'yes',
               'default' => 'no',
           ]
       );

       $this->add_control(
           'show_titles',
           [
               'label' => __( 'نمایش عنوان اسلاید بجای دکمه های پیشمایش', 'emperor' ),
               'type' => Controls_Manager::SWITCHER,
               'label_on' => __( 'بله', 'emperor' ),
               'label_off' => __( 'خیر', 'emperor' ),
               'return_value' => 'yes',
               'default' => 'no',
           ]
       );

      $this->end_controls_section();
   }

   protected function render( $instance = [] ) {

       $settings = $this->get_settings_for_display();
       ?>

       <div class="emperor-simple-slider-holder">
           <div class="emperor-simple-slider owl-carousel" <?php if ( 'yes' === $settings['show_titles'] ) { echo 'data-itemdotsc="#slider-title"'; } ?> <?php if ( 'yes' === $settings['show_arrows'] ) { echo 'data-itemnavs="true"'; } else { echo 'data-itemnavs="false"'; } ?> <?php if ( 'yes' === $settings['show_dots'] ) { echo 'data-itemdots="true"'; } else { echo 'data-itemdots="false"'; } ?> <?php if ( 'yes' === $settings['auto_play'] ) { echo 'data-itemplay="true"'; echo 'data-itemtime="'. $settings['time'] .'"'; } else { echo 'data-itemplay="false"'; } ?> <?php if ( 'yes' === $settings['pause_over'] ) { echo 'data-itemover="true"'; } else { echo 'data-itemover="false"'; } ?>">
               <?php if ( $settings['slides'] ) {
                   foreach (  $settings['slides'] as $item ) {
                       $target = $item['slide_link']['is_external'] ? ' target="_blank"' : '';
                       $nofollow = $item['slide_link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
                       <div class="item">
                           <?php if(!empty($item['slide_link']['url'])) { ?>
                           <a href="<?php echo $item['slide_link']['url']; ?>" title="<?php echo $item['slide_title']; ?>"<?php if(!empty($target)) { echo $target;} ?> <?php if(!empty($nofollow)) { echo $nofollow;} ?>>
                               <?php } ?>
                               <img src="<?php echo $item['slide_image']['url']; ?>" alt="<?php echo $item['slide_title']; ?>" class="slider-img" data-skip-lazy="">
                               <?php if(!empty($item['slide_link']['url'])) { ?>
                           </a>
                       <?php } ?>
                       </div>
                   <?php } } ?>
           </div>
           <?php if ( 'yes' === $settings['show_titles'] ) { ?>
               <div class="slider-title-outer">
                   <ul id="slider-title" class="">
                       <?php if ( $settings['slides'] ) {
                           foreach (  $settings['slides'] as $item ) { ?>
                               <li>
                                   <span class="slide-title"><?php echo $item['slide_title']; ?></span>
                               </li>
                           <?php } } ?>
                   </ul>
               </div>
           <?php } ?>
       </div>
       <?php

   }

    public function get_script_depends() {
        return [ 'keloncloud-theme', 'emperor-slider-handle' ];
    }

}
Plugin::instance()->widgets_manager->register_widget_type( new keloncloud_Widget_Simple_Slider );
