<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class keloncloud_Widget_search extends Widget_Base {

    public function get_name() {
        return 'search';
    }

    public function get_title() {
        return esc_html__( 'جستجو', 'emperor' );
    }

    public function get_icon() {
        return 'eicon-search-bold';
    }

    public function get_categories() {
        return [ 'emperor-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'search_section',
            [
                'label' => esc_html__( 'Search', 'emperor' ),
                'type' => Controls_Manager::SECTION,
            ]
        );

        $this->add_control(
            'placeholder',
            [
                'label' => __( 'متن باکس جستجو', 'emperor' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'چی دوست داری یاد بگیری...؟!', 'emperor' ),
            ]
        );

        $this->add_control(
            'input-height',
            [
                'label' => __( 'ارتفاع فیلد (px)', 'elementor' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'به پیکسل', 'elementor' ),
            ]
        );
        $this->add_control(
            'input-bg',
            [
                'label' => __( 'پس زمینه فیلد', 'emperor' ),
                'type' => Controls_Manager::COLOR,
            ]
        );
        $this->add_control(
            'btn-bg',
            [
                'label' => __( 'رنگ دکمه', 'emperor' ),
                'type' => Controls_Manager::COLOR,
            ]
        );
        $this->add_control(
            'btn-padding',
            [
                'label' => __( 'پدینگ دکمه (px)', 'elementor' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'به پیکسل', 'elementor' ),
            ]
        );

        $this->end_controls_section();

    }

    protected function render( $instance = [] ) {

        $settings = $this->get_settings_for_display(); ?>

        <form class="keloncloud-search-form all-in" method="GET" action="<?php echo esc_url(home_url( '/' )); ?>">
            <input style="height: <?php echo $settings['input-height'] ?>px !important; background: <?php echo $settings['input-bg'] ?> !important;" autocomplete="off" type="text" name="s" id="keyword" onkeyup="fetch()" placeholder="<?php echo esc_html($settings['placeholder']) ?>">
            <button style="background: <?php echo $settings['btn-bg'] ?> !important; padding: <?php echo $settings['btn-padding'] ?>px !important;" type="submit"><i class="fal fa-search"></i></button>
            <input type="hidden" name="dabir_search_post_type" value="product" />
        </form>
        <div id="keloncloud-data-fetch"></div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type( new keloncloud_Widget_search );
