<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

class keloncloud_Widget_search_btn extends Widget_Base
{

    public function get_name()
    {
        return 'search_btn';
    }

    public function get_title()
    {
        return esc_html__('آیکون جستجو', 'emperor');
    }

    public function get_icon()
    {
        return 'eicon-search';
    }

    public function get_categories()
    {
        return ['emperor-header-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'search_btn_section',
            [
                'label' => esc_html__('آیکون جستجو', 'emperor'),
                'type' => Controls_Manager::SECTION,
            ]
        );

        $this->add_control(
            'border',
            [
                'label' => __( 'گوشه های گرد (px)', 'elementor' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'به پیکسل', 'elementor' ),
                'default' => __( '5', 'elementor' ),
            ]
        );
        $this->add_control(
            'fontsize',
            [
                'label' => __( 'سایز آیکون (px)', 'elementor' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'به پیکسل', 'elementor' ),
                'default' => __( '20', 'elementor' ),
            ]
        );
        $this->add_control(
            'back',
            [
                'label' => __( 'پس زمینه', 'emperor' ),
                'type' => Controls_Manager::COLOR,
            ]
        );
        $this->add_control(
            'color',
            [
                'label' => __( 'رنگ', 'emperor' ),
                'type' => Controls_Manager::COLOR,
            ]
        );

        $this->end_controls_section();
    }

    protected function render($instance = [])
    {
        $settings = $this->get_settings_for_display();
        global $post;
        ?>


        <a href="#" class="emperor-search-btn">
            <div class="top-bar-cart search" style="background: <?php echo $settings['back'] ?> !important; border-radius: <?php echo $settings['border'] ?>px !important;">
                <i class="fal fa-search" style="color: <?php echo $settings['color'] ?> !important; font-size: <?php echo $settings['fontsize'] ?>px !important; "></i>
            </div>
        </a>


        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new keloncloud_Widget_search_btn);
