<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class keloncloud_Widget_products_teacher extends Widget_Base {

   public function get_name() {
      return 'Products-teacher';
   }

   public function get_title() {
      return esc_html__( 'دوره ها بر اساس مدرس', 'emperor' );
   }

   public function get_icon() {
        return 'eicon-form-vertical';
   }

   public function get_categories() {
      return [ 'emperor-elements' ];
   }

   protected function _register_controls() {

      $this->start_controls_section(
         'products_section',
         [
            'label' => esc_html__( 'Products', 'emperor' ),
            'type' => Controls_Manager::SECTION,
         ]
      );

      $this->add_control(
         'columns',
         [
            'label' => __( 'Columns', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'col-md-4',
            'options' => [
               'col-md-12'  => __( 'Column 1', 'emperor' ),
               'col-md-6' => __( 'Column 2', 'emperor' ),
               'col-md-4' => __( 'Column 3', 'emperor' ),
               'col-md-3' => __( 'Column 4', 'emperor' ),
               'col-md-2' => __( 'Column 6', 'emperor' ),
               'col-md-1' => __( 'Column 12', 'emperor' ),
            ],
         ]
      );

      $this->add_control(
         'category',
         [
            'label' => esc_html__( 'Category', 'emperor' ),
            'type' => Controls_Manager::SELECT2,
            'title' => esc_html__( 'Select a category', 'emperor' ),
            'multiple' => true,
            'options' => keloncloud_get_terms_dropdown_array([
               'taxonomy' => 'product_cat',
               'hide_empty' => false,
            ]),
         ]
      );


      $this->add_control(
			'ids',
			[
				'label'     => esc_html_x( 'انتخاب استاد', 'emperor' ),
				'description' => esc_html_x('نمایش دوره بر اساس مدرس انتخاب شده (این افزونه با فقط )', 'emperor' ),
				'type'      =>  Controls_Manager::SELECT2,
				'default'    =>  "",
				'multiple' => false,
				"options"    => keloncloud_elementor_teacher_list(),
			]

		);

      $this->add_control(
         'ppp',
         [
            'label' => __( 'Number of Items', 'emperor' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
               'no' => [
                  'min' => 0,
                  'max' => 100,
                  'step' => 1,
               ],
            ],
            'default' => [
               'size' => 3,
            ]
         ]
      );

      $this->add_control(
         'order',
         [
            'label' => __( 'order', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'DESC',
            'options' => [
               'ASC'  => __( 'Ascending', 'emperor' ),
               'DESC' => __( 'Descending', 'emperor' )
            ],
         ]
      );

      $this->end_controls_section();

   }

   protected function render( $instance = [] ) {
      if(! class_exists('WeDevs_Dokan')){
          $settings = $this->get_settings_for_display(); ?>
          <div class="elementor-products products row">
              <?php

              $prefix = '_keloncloud_';
              $teacher_id = get_post_meta( get_the_ID(), $prefix . 'course_teacher', true );

              $category = !empty( $settings['category'] ) ? $settings['category'] : 'All';
              $ids = ! empty( $settings["ids"] ) ? $settings["ids"] : 'All';

              $meta_query[] = array(
                  'key' => '_keloncloud_course_teacher',
                  'value' => $ids
              );

              $products = new \WP_Query( array(
                  'post_type' => 'product',
                  'posts_per_page' => $settings['ppp']['size'],
                  'order' => $settings['order'],
                  'tax_query'     => array(
                      array(
                          'taxonomy'  => 'product_cat',
                          'field'     => 'id',
                          'terms'     => $category,

                      )
                  ),
                  'meta_query' => $meta_query

              ));

              /* Start the Loop */
              while ( $products->have_posts() ) : $products->the_post(); ?>
                  <!-- Item -->
                  <div class="<?php echo esc_attr($settings['columns']) ?>">
                      <?php get_template_part( 'woocommerce/content-product-carousel' ); ?>
                  </div>

              <?php
              endwhile;
              wp_reset_postdata();
              ?>
          </div>
          <?php
      }else{
          ?>
            <p>شما افزونه دکان را نصب دارید، این المان در حالت نصب دکان در دسترس نیست! برای استفاده از این المان باید افزونه دکان را غیر فعال و از سیستم مدرسین اختصاصی قالب دبیر استفاده کنید.</p>
          <?php
      }

   }

}

Plugin::instance()->widgets_manager->register_widget_type( new keloncloud_Widget_products_teacher );
