<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class keloncloud_Widget_products_icon_carousel extends Widget_Base {

    public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);

        global $theme_version;
        $theme_obj     = wp_get_theme();
        $theme_version = $theme_obj->get( 'Version' );

        wp_register_script( 'emperor-product-icon-carousel-handle', get_theme_file_uri( 'assets/js/elementor/product-icon-carousel.js' ) , [ 'elementor-frontend' ], $theme_version, true );
    }

   public function get_name() {
      return 'Carousel_Icon_Products';
   }

   public function get_title() {
      return esc_html__( 'کروسل محصولات حالت آیکون', 'emperor' );
   }

   public function get_icon() {
        return 'eicon-form-vertical';
   }

   public function get_categories() {
      return [ 'emperor-elements' ];
   }

   protected function _register_controls() {

      $this->start_controls_section(
         'products_section',
         [
            'label' => esc_html__( 'کروسل محصولات حالت آیکون', 'emperor' ),
            'type' => Controls_Manager::SECTION,
         ]
      );


	  $this->add_control(
         'pagination',
         [
            'label' => __( 'صفحه گذاری اسلایدر', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'yes',

         ]
      );

	  $this->add_control(
         'navigation',
         [
            'label' => __( 'فلش های ناوبری', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'yes',

         ]
      );

	  $this->add_control(
         'loop',
         [
            'label' => __( 'حلقه کروسل', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'yes',

         ]
      );

	  $this->add_control(
         'autoplay',
         [
            'label' => __( 'اجرای خودکار اسلایدر', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'yes',

         ]
      );

      $this->add_control(
         'category',
         [
            'label' => esc_html__( 'Category', 'emperor' ),
            'type' => Controls_Manager::SELECT2,
            'title' => esc_html__( 'Select a category', 'emperor' ),
            'multiple' => true,
            'options' => keloncloud_get_terms_dropdown_array([
               'taxonomy' => 'product_cat',
               'hide_empty' => false,
            ]),
         ]
      );

      $this->add_control(
         'ppp',
         [
            'label' => __( 'Number of Items', 'emperor' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
               'no' => [
                  'min' => 0,
                  'max' => 100,
                  'step' => 1,
               ],
            ],
            'default' => [
               'size' => 3,
            ]
         ]
      );

      $this->add_control(
         'order',
         [
            'label' => __( 'order', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'DESC',
            'options' => [
               'ASC'  => __( 'Ascending', 'emperor' ),
               'DESC' => __( 'Descending', 'emperor' )
            ],
         ]
      );

      $this->end_controls_section();

   }

   protected function render( $instance = [] ) {

      $settings = $this->get_settings_for_display();
	  $carousel_data = array();
	  $carousel_data['data-pagination'] = $settings['pagination'];
	  $carousel_data['data-navigation'] = $settings['navigation'];
	  $carousel_data['data-loop'] = $settings['loop'];
	  $carousel_data['data-autoplay'] = $settings['autoplay'];


	  ?>

      <div class="elementor-products-icon-carousel">
	  <div class="owl-carousel" <?php echo keloncloud_get_inline_attrs( $carousel_data ); ?>>
         <?php

         $category = !empty( $settings['category'] ) ? $settings['category'] : 'All';

         $products = new \WP_Query( array(
            'post_type' => 'product',
            'posts_per_page' => $settings['ppp']['size'],
            'order' => $settings['order'],
            'tax_query'     => array(
                 array(
                     'taxonomy'  => 'product_cat',
                     'field'     => 'id',
                     'terms'     => $category
                 )
             )

         ));


         /* Start the Loop */
         while ( $products->have_posts() ) : $products->the_post();
             global $product;
             $prefix = '_keloncloud_';
             $product_icon = get_post_meta(get_the_ID(), $prefix . 'emperor_product_icon', true);

             $vip_status = false;
             if (is_plugin_active('restrict-content-pro/restrict-content-pro.php')){
                 $vip_status = get_post_meta(get_the_ID(), $prefix . 'course_vip_access', true);
             }

         ?>

             <div class="product-icon-item-holder" data-title="<?php the_title(); ?>" data-price="<?php echo $vip_status ? 'اعضای ویژه' : $product->get_price(); ?>" data-cover="<?php echo get_the_post_thumbnail_url( $product->id) ?>">
                 <div class="product-icon-item">
                     <a href="<?php the_permalink() ?>">
                         <img src="<?php echo esc_url($product_icon); ?>" alt="<?php the_title(); ?>">
                     </a>
                 </div>
             </div>

         <?php
         endwhile;
      wp_reset_postdata();
      ?>
      </div>
	  </div>
   <?php
   }

    public function get_script_depends() {
        return [ 'keloncloud-theme', 'emperor-product-icon-carousel-handle' ];
    }


}

Plugin::instance()->widgets_manager->register_widget_type( new keloncloud_Widget_products_icon_carousel );
