<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class keloncloud_Widget_paths_carousel extends Widget_Base {

    public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);

        global $theme_version;
        $theme_obj     = wp_get_theme();
        $theme_version = $theme_obj->get( 'Version' );

        wp_register_script( 'emperor-paths-carousel-handle', get_theme_file_uri( 'assets/js/elementor/paths-carousel.js' ) , [ 'elementor-frontend' ], $theme_version, true );
    }

   public function get_name() {
      return 'Carousel_Paths';
   }

   public function get_title() {
      return esc_html__( 'کروسل مسیرها', 'emperor' );
   }

   public function get_icon() {
        return 'eicon-form-vertical';
   }

   public function get_categories() {
      return [ 'emperor-elements' ];
   }

   protected function _register_controls() {

       $this->start_controls_section(
           'paths_setting_section',
           [
               'label' => esc_html__( 'تنظیمات', 'emperor' ),
               'type' => Controls_Manager::SECTION,
           ]
       );

       $this->add_control(
           'pagination',
           [
               'label' => __( 'صفحه گذاری اسلایدر', 'emperor' ),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'default' => 'yes',

           ]
       );

       $this->add_control(
           'navigation',
           [
               'label' => __( 'فلش های ناوبری', 'emperor' ),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'default' => 'yes',

           ]
       );

       $this->add_control(
           'loop',
           [
               'label' => __( 'حلقه کروسل', 'emperor' ),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'default' => 'yes',

           ]
       );

       $this->add_control(
           'autoplay',
           [
               'label' => __( 'اجرای خودکار اسلایدر', 'emperor' ),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'default' => 'yes',

           ]
       );

       $this->end_controls_section();

      $this->start_controls_section(
         'paths_section',
         [
            'label' => esc_html__( 'مسیر ها', 'emperor' ),
            'type' => Controls_Manager::SECTION,
         ]
      );


       $repeater = new \Elementor\Repeater();


       $repeater->add_control(
           'title_path',
           [
               'label' => __('عنوان مسیر', 'emperor'),
               'type' => \Elementor\Controls_Manager::TEXT,

           ]
       );

       $repeater->add_control(
           'desc_path',
           [
               'label' => __('توضیح کوتاه مسیر', 'emperor'),
               'type' => \Elementor\Controls_Manager::TEXT,

           ]
       );

       $repeater->add_control(
           'label_path',
           [
               'label' => __('لیبل مسیر', 'emperor'),
               'type' => \Elementor\Controls_Manager::TEXT,

           ]
       );


       $repeater->add_control(
           'icon_path',
           [
               'label' => __('آیکون مسیر', 'emperor'),
               'type' => \Elementor\Controls_Manager::MEDIA
           ]
       );

       $repeater->add_control(
           'label_path',
           [
               'label' => __('لیبل مسیر', 'emperor'),
               'type' => \Elementor\Controls_Manager::TEXT,

           ]
       );

       $repeater->add_control(
           'text_link_path',
           [
               'label' => __('عنوان لینک', 'emperor'),
               'type' => \Elementor\Controls_Manager::TEXT,

           ]
       );
       $repeater->add_control(
           'link_path',
           [
               'label' => __('آدرس لینک', 'emperor'),
               'type' => \Elementor\Controls_Manager::URL,

           ]
       );


       $this->add_control(
           'path_list',
           [
               'label' => __('لیست مسیر ها', 'emperor'),
               'type' => \Elementor\Controls_Manager::REPEATER,
               'fields' => $repeater->get_controls(),
               'title_field' => '{{{title_path}}}',

           ]
       );

      $this->end_controls_section();

   }

   protected function render( $instance = [] ) {

      $settings = $this->get_settings_for_display();

       $carousel_data = array();
       $carousel_data['data-pagination'] = $settings['pagination'];
       $carousel_data['data-navigation'] = $settings['navigation'];
       $carousel_data['data-loop'] = $settings['loop'];
       $carousel_data['data-autoplay'] = $settings['autoplay'];

	  ?>


      <div class="elementor-products products courses-holder">
	  <div class="owl-carousel" <?php echo keloncloud_get_inline_attrs( $carousel_data ); ?>>

       <?php foreach ($settings['path_list'] as $path): ?>
           <div class="course-item path-item">
               <div class="course-item-inner">

                   <div class="course-content-holder">

                       <div class="course-content-main">
                          <div class="p-3">
                              <div class="d-flex align-items-center justify-content-between mb-4">
                                  <img src="<?php echo $path['icon_path']['url'] ?>" alt="<?php echo $path['title_path'] ?>">
                                  <span class="label"><?php echo $path['label_path'] ?></span>
                              </div>
                              <h3 class="course-title mb-2">
                                  <a href="<?php echo $path['link_path']['url'] ?>"><?php echo $path['title_path'] ?></a>
                              </h3>
                              <p class="desc"><?php echo $path['desc_path'] ?></p>
                          </div>
                           <div class="more-holder mb-0">
                               <a href="<?php echo $path['link_path']['url'] ?>">
                                   <span><?php echo $path['text_link_path'] ?></span>
                                   <i class="fal fa-arrow-left mx-2"></i>
                               </a>
                           </div>
                       </div>
                   </div>

               </div>
           </div>
       <?php endforeach; ?>


      </div>
	  </div>
   <?php
   }


    public function get_script_depends() {
        return [ 'keloncloud-theme', 'emperor-paths-carousel-handle' ];
    }


}

Plugin::instance()->widgets_manager->register_widget_type( new keloncloud_Widget_paths_carousel );
