<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;


class keloncloud_Widget_namad_slider extends Widget_Base
{
    public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);

        global $theme_version;
        $theme_obj     = wp_get_theme();
        $theme_version = $theme_obj->get( 'Version' );

        wp_register_script( 'emperor-namad-slider-handle', get_theme_file_uri( 'assets/js/elementor/namad.js' ) , [ 'elementor-frontend' ], $theme_version, true );
    }

    public function get_name()
    {
        return 'namad-slider';
    }

    public function get_title()
    {
        return esc_html__('اسلایدر نمادها', 'emperor');
    }

    public function get_icon()
    {
        return 'eicon-post-slider';
    }

    public function get_categories()
    {
        return ['emperor-footer-elements'];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'links_section',
            [
                'label' => esc_html__('آیتم ها', 'emperor'),
                'type' => Controls_Manager::SECTION,
            ]
        );

        $repeater = new \Elementor\Repeater();


        $repeater->add_control(
            'title',
            [
                'label' => __('عنوان نماد', 'emperor'),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );


        $repeater->add_control(
            'html',
            [
                'label' => __('کد نماد', 'emperor'),
                'type' => \Elementor\Controls_Manager::WYSIWYG
            ]
        );

        $this->add_control(
            'namad-list',
            [
                'label' => __('نمادها', 'emperor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{title}}}',

            ]
        );


        $this->end_controls_section();


    }

    protected function render($instance = [])
    {
        $settings = $this->get_settings_for_display();

        global $post;
        ?>

        <?php if (get_post_type($post->ID) != 'keloncloudfooter'):  echo 'این المان فقط در فوتر ها قابل استفاده است!';?>
        <?php else: ?>

            <div class="namad-slider">
                <div class="owl-carousel">
                    <?php foreach ($settings['namad-list'] as $item): ?>
                       <div class="namad-inner"><?php echo $item['html'] ?></div>
                    <?php endforeach; ?>
                </div>
            </div>

        <?php endif; ?>

    <?php }

    public function get_script_depends() {
        return [ 'keloncloud-theme', 'emperor-namad-slider-handle' ];
    }


}

Plugin::instance()->widgets_manager->register_widget_type(new keloncloud_Widget_namad_slider);
