<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;


class keloncloud_Widget_footer_menu extends Widget_Base
{
    public function get_name()
    {
        return 'footer_menu';
    }

    public function get_title()
    {
        return esc_html__('منو فوتر', 'emperor');
    }

    public function get_icon()
    {
        return 'eicon-editor-list-ul';
    }

    public function get_categories()
    {
        return ['emperor-footer-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'footer_menu_section',
            [
                'label' => esc_html__('تنظیمات منو', 'emperor'),
                'type' => Controls_Manager::SECTION,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('عنوان', 'emperor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'فهرست منو',

            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'links_section',
            [
                'label' => esc_html__('آیتم ها', 'emperor'),
                'type' => Controls_Manager::SECTION,
            ]
        );

        $repeater = new \Elementor\Repeater();


        $repeater->add_control(
            'title',
            [
                'label' => __('عنوان', 'emperor'),
                'type' => \Elementor\Controls_Manager::TEXT,

            ]
        );


        $repeater->add_control(
            'url',
            [
                'label' => __('لینک', 'emperor'),
                'type' => \Elementor\Controls_Manager::URL
            ]
        );

        $this->add_control(
            'links',
            [
                'label' => __('آیتم های منو', 'emperor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{title}}}',

            ]
        );


        $this->end_controls_section();


    }

    protected function render($instance = [])
    {
        $settings = $this->get_settings_for_display();

        global $post;
        ?>


        <div class="footer-menu">
            <h5 class="title"><?php echo $settings['title'] ?></h5>
            <ul>
                <?php foreach ($settings['links'] as $link): ?>
                    <li>
                        <a href="<?php echo esc_url($link['url']['url']) ?>">
                            <?php echo $link['title'] ?>
                        </a>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>

    <?php }

}

Plugin::instance()->widgets_manager->register_widget_type(new keloncloud_Widget_footer_menu);
