<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class keloncloud_Widget_download extends Widget_Base {

   public function get_name() {
      return 'download';
   }

   public function get_title() {
      return esc_html__( 'محصولات با فیلتر دسته بندی', 'emperor' );
   }

   public function get_icon() {
        return 'eicon-gallery-masonry';
   }

   public function get_categories() {
      return [ 'emperor-elements' ];
   }

   protected function _register_controls() {

      $this->start_controls_section(
         'download_section',
         [
            'label' => esc_html__( 'Download', 'emperor' ),
            'type' => Controls_Manager::SECTION,
         ]
      );


      $this->add_control(
         'category',
         [
            'label' => esc_html__( 'Category', 'emperor' ),
            'type' => Controls_Manager::SELECT2,
            'title' => esc_html__( 'Select a category', 'emperor' ),
            'multiple' => true,
            'options' => keloncloud_get_terms_dropdown_array([
               'taxonomy' => 'product_cat',
               'hide_empty' => false,
            ]),
         ]
      );

      $this->add_control(
         'filter',
         [
            'label' => __( 'Filter', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => __( 'Yes', 'emperor' ),
            'label_off' => __( 'No', 'emperor' ),
            'return_value' => 'yes',
            'default' => 'yes'
         ]
      );

      $this->add_control(
         'ppp',
         [
            'label' => __( 'Number of Items', 'emperor' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
               'no' => [
                  'min' => 0,
                  'max' => 100,
                  'step' => 1,
               ],
            ],
            'default' => [
               'size' => 9,
            ]
         ]
      );

      $this->add_control(
         'order',
         [
            'label' => __( 'order', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'DESC',
            'options' => [
               'ASC'  => __( 'Ascending', 'emperor' ),
               'DESC' => __( 'Descending', 'emperor' )
            ],
         ]
      );

      $this->end_controls_section();

   }

   protected function render( $instance = [] ) {

      $settings = $this->get_settings_for_display(); ?>

      <div class="container">
         <?php if ( 'yes' == $settings['filter'] ) {?>
            <div class="keloncloud-filter-product">
               <ul class="list-inline">
                  <li class="list-inline-item product-filter select-cate" data-product-cat="<?php foreach ( $settings['category'] as $category ) { echo esc_attr( get_term_by('id', $category, 'product_cat')->slug ).','; } ?>"><?php echo esc_html__( 'همه دسته ها', 'emperor' ) ?></li>

                  <?php

                  if ( $settings['category'] ) {

                     foreach ( $settings['category'] as $category ) { ?>

                     <li class="list-inline-item product-filter" data-product-cat="<?php echo esc_attr( get_term_by('id', $category, 'product_cat')->slug ) ?>"><?php echo esc_html( get_term_by('id', $category, 'product_cat')->name ) ?></li>

                     <?php }
                  } ?>
               </ul>
            </div>
            <div class="lds-facebook"><div></div><div></div><div></div></div>
         <?php } ?>

         <div class="elementor-products products keloncloud-filter-product-items row">
            <div class="lds-facebook"><div></div><div></div><div></div></div>
            <?php

            $category = !empty( $settings['category'] ) ? $settings['category'] : 'All';

            $download = new \WP_Query( array(
               'post_type' => 'product',
               'posts_per_page' => $settings['ppp']['size'],
               'order' => $settings['order'],
               'tax_query'     => array(
                  array(
                     'taxonomy'  => 'product_cat',
                     'field'     => 'id',
                     'terms'     => $category
                  ),
                  array(
                     'taxonomy' =>   'product_visibility',
                     'field'    =>   'name',
                     'terms'    =>   array('exclude-from-search', 'exclude-from-catalog'),
                     'operator' =>   'NOT IN'
                  )
               )
            ));

            /* Start the Loop */
            while ( $download->have_posts() ) : $download->the_post(); ?>
               <!-- Item -->
               <div class="col-lg-4 col-md-4">
              <?php get_template_part( 'woocommerce/content-product-carousel' ); ?>
               </div>

            <?php
            endwhile;
         wp_reset_postdata();
         ?>
         </div>
      </div>
   <?php
   }

}

Plugin::instance()->widgets_manager->register_widget_type( new keloncloud_Widget_download );
