<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class keloncloud_Widget_Dividers extends Widget_Base {

    public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);

        global $theme_version;
        $theme_obj     = wp_get_theme();
        $theme_version = $theme_obj->get( 'Version' );


        wp_register_script( 'emperor-dividers-handle', get_theme_file_uri( 'assets/js/elementor/dividers.js' ) , [ 'elementor-frontend' ], $theme_version, true );
    }

    public function get_name() {
        return 'emperor-dividers';
    }

    public function get_title() {
        return 'جداکننده اختصاصی';
    }

    public function get_icon() {
        return 'fa fa-list-ul';
    }

    public function get_categories() {
        return [ 'emperor-elements' ];
    }

    protected function _register_controls() {


        // ===========================================
        // Bottom Dividers
        // ===========================================
        $this->start_controls_section(
            'section_bottom_dividers',
            [
                'label' => __( 'جداکننده پایین', 'elementor' ),
            ]
        );

        $fontiocns_opts = array();
        $fontiocns_opts['0'] = array('title' => 'None', 'url' => get_theme_file_uri('assets/images/elementor/shapes/none.png'));
        $fontiocns_opts['dynamic'] = array('title' => 'Dynamic', 'url' => get_theme_file_uri('assets/images/elementor/shapes/divider-dynamic.gif'));
        for ($x = 1; $x <= 23; $x++) {
            $fontiocns_opts[$x] = array('title' => 'Style '.$x, 'url' => get_theme_file_uri('assets/images/elementor/shapes/divider-'.$x.'.png'));
        }

        $this->add_control(
            'bottom_divider_select',
            [
                'label' => esc_html__('آیکون', 'text-domain'),
                'type' => \Elementor\CustomControl\ImgSelector_Control::ImgSelector,
                'options'	=> $fontiocns_opts,
                'default' => '0',
                'class' => 'firas',

            ]
        );
        $this->add_control(
            'bottom_moving_divider_color',
            [
                'label' => __( 'جداکننده های پایین', 'emperor' ),
                'type' => Controls_Manager::REPEATER,
                'default'	=> [
                    ['d_gradient'	=> ''],
                    []
                ],
                'fields' => [
                    [
                        'name' => 'd_gradient',
                        'label' => __( 'گرادینت؟', 'emperor' ),
                        'type' => \Elementor\Controls_Manager::SWITCHER,
                        'label_on' => __( 'بله', 'emperor' ),
                        'label_off' => __( 'خیر', 'emperor' ),
                        'return_value' => '1',
                        'default' => '',
                    ],
                    [
                        'name' => 'd_color_1',
                        'label' => __( 'رنگ اول', 'plugin-name' ),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'default' => '#f8f9fa',
                    ],
                    [
                        'name' => 'd_color_2',
                        'label' => __( 'رنگ دوم', 'plugin-name' ),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'default' => '#f8f9fa',
                        'condition' => [
                            'd_gradient!' => '',
                        ],
                    ]



                ],
                'condition' => [
                    'bottom_divider_select' => 'dynamic',
                ],
            ]
        );
        $this->add_control(
            'bottom_layers',
            [
                'label' => __( 'تعداد لایه ها', 'emperor' ),
                'type' => Controls_Manager::SELECT,
                'default' => '3',
                'options' => array(
                    "1"       => "1 لایه",
                    "2"       => "2 لایه",
                    "3"       => "3 لایه",
                ),
                'condition' => [
                    'bottom_divider_select' => array("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23")
                ],
            ]
        );
        $this->add_control(
            'b_has_animation',
            [
                'label' => __( 'فعال شدن انیمیشن برای لایه ها', 'emperor' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'بله', 'emperor' ),
                'label_off' => __( 'خیر', 'emperor' ),
                'return_value' => 'font-weight-bold',
                'default' => false,
                'condition' => [
                    'bottom_layers!' => '',
                ],
            ]
        );
        $this->add_control(
            'b_divider_in_front',
            [
                'label' => __( 'جداکننده به جلو محتوا بیاید؟', 'emperor' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'بله', 'emperor' ),
                'label_off' => __( 'خیر', 'emperor' ),
                'return_value' => true,
                'default' => false,
            ]
        );
        $this->add_control(
            'b_flip_h',
            [
                'label' => __( 'چرخاندن جداکننده؟', 'emperor' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'بله', 'emperor' ),
                'label_off' => __( 'خیر', 'emperor' ),
                'return_value' => true,
                'default' => false,
            ]
        );
        $this->add_control(
            'b_custom_height',
            [
                'label' => __( 'ارتفاع سفارشی جداکننده', 'emperor' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '0', 'emperor' ),
                'placeholder' => __( 'ارتباع بر اساس پیکسل مانند: 200px', 'emperor' ),
                // 'condition' => [
                // 	'b_2_animation!' => '',
                // ],
            ]
        );

        $this->end_controls_section();




        $this->start_controls_section(
            'section_bottom_dividers_1',
            [
                'label' => __( 'اولین لایه پایین', 'elementor' ),
                'condition' => [
                    'bottom_divider_select' => array("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23")
                ],
            ]
        );

        $this->add_control(
            'b_1_is_gradient',
            [
                'label' => __( 'استفاده از گرادینت برای لایه اول؟', 'emperor' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'بله', 'emperor' ),
                'label_off' => __( 'خیر', 'emperor' ),
                'return_value' => true,
                'default' => false,
                // 'condition' => [
                // 	'bottom_layers!' => '',
                // ],
            ]
        );
        $this->add_control(
            'b_1_color',
            [
                'label' => __( 'رنگ اول لایه اول', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                // 'condition' => [
                // 	'icon_color' => 'custom',
                // ],
            ]
        );
        $this->add_control(
            'b_1_color_2',
            [
                'label' => __( 'رنگ دوم لایه اول', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'condition' => [
                    'b_1_is_gradient!' => '',
                ],
            ]
        );
        $this->add_control(
            'b_1_animation',
            [
                'label' => __( 'انیمیشن', 'emperor' ),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => array_flip(array(
                    "None" 				=> "",
                    "Fade in" 			=> "fade-in",
                    'fade-in-down'		=> 'fade-in-down',
                    'fade-in-left'		=> 'fade-in-left',
                    'fade-in-right'		=> 'fade-in-right',
                    'fade-in-up'		=> 'fade-in-up',
                    'fade-in-up-big'	=> 'fade-in-up-big',
                    'fade-in-right-big'	=> 'fade-in-right-big',
                    'fade-in-left-big'	=> 'fade-in-left-big',
                    "Slide in up"		=> "slide-in-up",
                    "Fade in & Scale"		=> "fade-in-Img",
                )),
                'condition' => [
                    'b_has_animation!' => '',
                ],
            ]
        );
        $this->add_control(
            'b_1_delay',
            [
                'label' => __( 'تاخیر انیمیشن بر حسب (میلی ثانیه)', 'emperor' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '0', 'emperor' ),
                'placeholder' => __( '', 'emperor' ),
                'condition' => [
                    'b_1_animation!' => '',
                ],
            ]
        );

        $this->end_controls_section();





        $this->start_controls_section(
            'section_bottom_dividers_2',
            [
                'label' => __( 'لایه دوم پایین', 'elementor' ),
                'condition' => [
                    'bottom_divider_select' => array("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23")
                ],
            ]
        );

        $this->add_control(
            'b_2_is_gradient',
            [
                'label' => __( 'گرادینت برای لایه دوم؟', 'emperor' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'بله', 'emperor' ),
                'label_off' => __( 'خیر', 'emperor' ),
                'return_value' => true,
                'default' => false,
                // 'condition' => [
                // 	'bottom_layers!' => '',
                // ],
            ]
        );
        $this->add_control(
            'b_2_color',
            [
                'label' => __( 'رنگ اول لایه دوم', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'rgba(255,255,255,0.6)',
                // 'condition' => [
                // 	'icon_color' => 'custom',
                // ],
            ]
        );
        $this->add_control(
            'b_2_color_2',
            [
                'label' => __( 'رنگ دوم لایه دوم', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'condition' => [
                    'b_2_is_gradient!' => '',
                ],
            ]
        );
        $this->add_control(
            'b_2_animation',
            [
                'label' => __( 'انیمیشن', 'emperor' ),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => array_flip(array(
                    "None" 				=> "",
                    "Fade in" 			=> "fade-in",
                    'fade-in-down'		=> 'fade-in-down',
                    'fade-in-left'		=> 'fade-in-left',
                    'fade-in-right'		=> 'fade-in-right',
                    'fade-in-up'		=> 'fade-in-up',
                    'fade-in-up-big'	=> 'fade-in-up-big',
                    'fade-in-right-big'	=> 'fade-in-right-big',
                    'fade-in-left-big'	=> 'fade-in-left-big',
                    "Slide in up"		=> "slide-in-up",
                    "Fade in & Scale"		=> "fade-in-Img",
                )),
                'condition' => [
                    'b_has_animation!' => '',
                ],
            ]
        );
        $this->add_control(
            'b_2_delay',
            [
                'label' => __( 'تاخیر انیمیشن بر حسب (میلی ثانیه)', 'emperor' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '0', 'emperor' ),
                'placeholder' => __( '', 'emperor' ),
                'condition' => [
                    'b_2_animation!' => '',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_bottom_dividers_3',
            [
                'label' => __( 'لایه سوم پایین', 'elementor' ),
                'condition' => [
                    'bottom_divider_select' => array("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23")
                ],
            ]
        );

        $this->add_control(
            'b_3_is_gradient',
            [
                'label' => __( 'گرداینت برای لایه سوم؟', 'emperor' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'بله', 'emperor' ),
                'label_off' => __( 'خیر', 'emperor' ),
                'return_value' => true,
                'default' => false,
            ]
        );
        $this->add_control(
            'b_3_color',
            [
                'label' => __( 'رنگ اول لایه سوم', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'rgba(255,255,255,0.3)',
                // 'condition' => [
                // 	'icon_color' => 'custom',
                // ],
            ]
        );
        $this->add_control(
            'b_3_color_2',
            [
                'label' => __( 'رنگ دوم لایه سوم', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'condition' => [
                    'b_3_is_gradient!' => '',
                ],
            ]
        );
        $this->add_control(
            'b_3_animation',
            [
                'label' => __( 'انیمیشن', 'emperor' ),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => array_flip(array(
                    "None" 				=> "",
                    "Fade in" 			=> "fade-in",
                    'fade-in-down'		=> 'fade-in-down',
                    'fade-in-left'		=> 'fade-in-left',
                    'fade-in-right'		=> 'fade-in-right',
                    'fade-in-up'		=> 'fade-in-up',
                    'fade-in-up-big'	=> 'fade-in-up-big',
                    'fade-in-right-big'	=> 'fade-in-right-big',
                    'fade-in-left-big'	=> 'fade-in-left-big',
                    "Slide in up"		=> "slide-in-up",
                    "Fade in & Scale"		=> "fade-in-Img",
                )),
                'condition' => [
                    'b_has_animation!' => '',
                ],
            ]
        );
        $this->add_control(
            'b_3_delay',
            [
                'label' => __( 'تاخیر انیمیشن بر حسب (میلی ثانیه)', 'emperor' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '0', 'emperor' ),
                'placeholder' => __( '', 'emperor' ),
                'condition' => [
                    'b_3_animation!' => '',
                ],
            ]
        );

        $this->end_controls_section();







        // ===========================================
        // top Dividers
        // ===========================================
        $this->start_controls_section(
            'section_top_dividers',
            [
                'label' => __( 'جداکننده بالا', 'elementor' ),
            ]
        );

        $fontiocns_opts = array();
        $fontiocns_opts['0'] = array('title' => 'None', 'url' => get_theme_file_uri('assets/images/elementor/shapes/none.png'));
        $fontiocns_opts['dynamic'] = array('title' => 'Dynamic', 'url' => get_theme_file_uri('assets/images/elementor/shapes/divider-dynamic.gif'));
        for ($x = 1; $x <= 23; $x++) {
            $fontiocns_opts[$x] = array('title' => 'Style '.$x, 'url' => get_theme_file_uri('assets/images/elementor/shapes/divider-'.$x.'.png'));
        }

        $this->add_control(
            'top_divider_select',
            [
                'label' => esc_html__('آیکون', 'text-domain'),
                'type' => \Elementor\CustomControl\ImgSelector_Control::ImgSelector,
                'options'	=> $fontiocns_opts,
                'default' => '0',
                'class' => 'emperor-top-dividers-select',
            ]
        );
        $this->add_control(
            'top_moving_divider_color',
            [
                'label' => __( 'جداکننده بالا', 'emperor' ),
                'type' => Controls_Manager::REPEATER,
                'default'	=> [
                    ['d_gradient'	=> ''],
                    []
                ],
                'fields' => [
                    [
                        'name' => 'd_gradient',
                        'label' => __( 'گرادینت؟', 'emperor' ),
                        'type' => \Elementor\Controls_Manager::SWITCHER,
                        'label_on' => __( 'Yes', 'emperor' ),
                        'label_off' => __( 'No', 'emperor' ),
                        'return_value' => '1',
                        'default' => '',
                    ],
                    [
                        'name' => 'd_color_1',
                        'label' => __( 'رنگ اول', 'plugin-name' ),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'default' => '#f8f9fa',
                    ],
                    [
                        'name' => 'd_color_2',
                        'label' => __( 'رنگ دوم', 'plugin-name' ),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'default' => '#f8f9fa',
                        'condition' => [
                            'd_gradient!' => '',
                        ],
                    ]



                ],
                'condition' => [
                    'top_divider_select' => 'dynamic',
                ],
            ]
        );
        $this->add_control(
            'top_layers',
            [
                'label' => __( 'تعداد لایه ها', 'emperor' ),
                'type' => Controls_Manager::SELECT,
                'default' => '3',
                'options' => array(
                    "1"       => "1 Layer",
                    "2"       => "2 Layer",
                    "3"       => "3 Layer",
                ),
                'condition' => [
                    'top_divider_select' => array("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23")
                ],
            ]
        );
        $this->add_control(
            't_has_animation',
            [
                'label' => __( 'فعالسازی انیمیشن لایه ها', 'emperor' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'emperor' ),
                'label_off' => __( 'No', 'emperor' ),
                'return_value' => 'font-weight-bold',
                'default' => false,
                'condition' => [
                    'top_layers!' => '',
                ],
            ]
        );
        $this->add_control(
            't_divider_in_front',
            [
                'label' => __( 'جداکننده به جلو محتوا بیاید؟', 'emperor' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'emperor' ),
                'label_off' => __( 'No', 'emperor' ),
                'return_value' => true,
                'default' => false,
            ]
        );
        $this->add_control(
            't_flip_h',
            [
                'label' => __( 'چرخاندن جداکننده؟', 'emperor' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'emperor' ),
                'label_off' => __( 'No', 'emperor' ),
                'return_value' => true,
                'default' => false,
            ]
        );
        $this->add_control(
            't_custom_height',
            [
                'label' => __( 'ارتفاع سفارشی جداکننده', 'emperor' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '0', 'emperor' ),
                'placeholder' => __( 'Height with unit, e.g: 200px', 'emperor' ),
                // 'condition' => [
                // 	't_2_animation!' => '',
                // ],
            ]
        );

        $this->end_controls_section();




        $this->start_controls_section(
            'section_top_dividers_1',
            [
                'label' => __( 'اولین لایه بالا', 'elementor' ),
                'condition' => [
                    'top_divider_select' => array("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23")
                ],
            ]
        );

        $this->add_control(
            't_1_is_gradient',
            [
                'label' => __( 'گرادینت لایه اول؟', 'emperor' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'emperor' ),
                'label_off' => __( 'No', 'emperor' ),
                'return_value' => true,
                'default' => false,
                // 'condition' => [
                // 	'top_layers!' => '',
                // ],
            ]
        );
        $this->add_control(
            't_1_color',
            [
                'label' => __( 'رنگ اول لایه اول', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                // 'condition' => [
                // 	'icon_color' => 'custom',
                // ],
            ]
        );
        $this->add_control(
            't_1_color_2',
            [
                'label' => __( 'رنگ دوم لایه اول', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'condition' => [
                    't_1_is_gradient!' => '',
                ],
            ]
        );
        $this->add_control(
            't_1_animation',
            [
                'label' => __( 'انیمیشن', 'emperor' ),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => array_flip(array(
                    "None" 				=> "",
                    "Fade in" 			=> "fade-in",
                    'fade-in-down'		=> 'fade-in-down',
                    'fade-in-left'		=> 'fade-in-left',
                    'fade-in-right'		=> 'fade-in-right',
                    'fade-in-up'		=> 'fade-in-up',
                    'fade-in-up-big'	=> 'fade-in-up-big',
                    'fade-in-right-big'	=> 'fade-in-right-big',
                    'fade-in-left-big'	=> 'fade-in-left-big',
                    "Slide in up"		=> "slide-in-up",
                    "Fade in & Scale"		=> "fade-in-Img",
                )),
                'condition' => [
                    't_has_animation!' => '',
                ],
            ]
        );
        $this->add_control(
            't_1_delay',
            [
                'label' => __( 'تاخیر انیمیشن بر حسب (میلی ثانیه)', 'emperor' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '0', 'emperor' ),
                'placeholder' => __( '', 'emperor' ),
                'condition' => [
                    't_1_animation!' => '',
                ],
            ]
        );

        $this->end_controls_section();



        $this->start_controls_section(
            'section_top_dividers_2',
            [
                'label' => __( 'لایه دوم بالا', 'elementor' ),
                'condition' => [
                    'top_divider_select' => array("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23")
                ],
            ]
        );

        $this->add_control(
            't_2_is_gradient',
            [
                'label' => __( 'گرادینت لایه دوم؟', 'emperor' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'emperor' ),
                'label_off' => __( 'No', 'emperor' ),
                'return_value' => true,
                'default' => false,
                // 'condition' => [
                // 	'top_layers!' => '',
                // ],
            ]
        );
        $this->add_control(
            't_2_color',
            [
                'label' => __( 'رنگ اول لایه دوم', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'rgba(255,255,255,0.6)',
                // 'condition' => [
                // 	'icon_color' => 'custom',
                // ],
            ]
        );
        $this->add_control(
            't_2_color_2',
            [
                'label' => __( 'رنگ دوم لایه دوم', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'condition' => [
                    't_2_is_gradient!' => '',
                ],
            ]
        );
        $this->add_control(
            't_2_animation',
            [
                'label' => __( 'انیمیشن', 'emperor' ),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => array_flip(array(
                    "None" 				=> "",
                    "Fade in" 			=> "fade-in",
                    'fade-in-down'		=> 'fade-in-down',
                    'fade-in-left'		=> 'fade-in-left',
                    'fade-in-right'		=> 'fade-in-right',
                    'fade-in-up'		=> 'fade-in-up',
                    'fade-in-up-big'	=> 'fade-in-up-big',
                    'fade-in-right-big'	=> 'fade-in-right-big',
                    'fade-in-left-big'	=> 'fade-in-left-big',
                    "Slide in up"		=> "slide-in-up",
                    "Fade in & Scale"		=> "fade-in-Img",
                )),
                'condition' => [
                    't_has_animation!' => '',
                ],
            ]
        );
        $this->add_control(
            't_2_delay',
            [
                'label' => __( 'تاخیر انیمیشن بر حسب (میلی ثانیه)', 'emperor' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '0', 'emperor' ),
                'placeholder' => __( '', 'emperor' ),
                'condition' => [
                    't_2_animation!' => '',
                ],
            ]
        );

        $this->end_controls_section();





        $this->start_controls_section(
            'section_top_dividers_3',
            [
                'label' => __( 'لایه سوم بالا', 'elementor' ),
                'condition' => [
                    'top_divider_select' => array("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23")
                ],
            ]
        );

        $this->add_control(
            't_3_is_gradient',
            [
                'label' => __( 'گرادینت لایه سوم؟', 'emperor' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'emperor' ),
                'label_off' => __( 'No', 'emperor' ),
                'return_value' => true,
                'default' => false,
            ]
        );
        $this->add_control(
            't_3_color',
            [
                'label' => __( 'رنگ اول لایه سوم', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'rgba(255,255,255,0.3)',
                // 'condition' => [
                // 	'icon_color' => 'custom',
                // ],
            ]
        );
        $this->add_control(
            't_3_color_2',
            [
                'label' => __( 'رنگ دوم لایه سوم', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'condition' => [
                    't_3_is_gradient!' => '',
                ],
            ]
        );
        $this->add_control(
            't_3_animation',
            [
                'label' => __( 'انیمیشن', 'emperor' ),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => array_flip(array(
                    "None" 				=> "",
                    "Fade in" 			=> "fade-in",
                    'fade-in-down'		=> 'fade-in-down',
                    'fade-in-left'		=> 'fade-in-left',
                    'fade-in-right'		=> 'fade-in-right',
                    'fade-in-up'		=> 'fade-in-up',
                    'fade-in-up-big'	=> 'fade-in-up-big',
                    'fade-in-right-big'	=> 'fade-in-right-big',
                    'fade-in-left-big'	=> 'fade-in-left-big',
                    "Slide in up"		=> "slide-in-up",
                    "Fade in & Scale"		=> "fade-in-Img",
                )),
                'condition' => [
                    't_has_animation!' => '',
                ],
            ]
        );
        $this->add_control(
            't_3_delay',
            [
                'label' => __( 'تاخیر انیمیشن بر حسب (میلی ثانیه)', 'emperor' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '0', 'emperor' ),
                'placeholder' => __( '', 'emperor' ),
                'condition' => [
                    't_3_animation!' => '',
                ],
            ]
        );

        $this->end_controls_section();


    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        echo sc_emperor_dividers($settings);
    }

    protected function _content_template() {

    }

    public function get_script_depends() {
        return [ 'keloncloud-theme', 'emperor-dividers-handle' ];
    }


}


Plugin::instance()->widgets_manager->register_widget_type( new keloncloud_Widget_Dividers );