<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;


class keloncloud_Widget_developer extends Widget_Base
{
    public function get_name()
    {
        return 'developer';
    }

    public function get_title()
    {
        return esc_html__('طراح', 'emperor');
    }

    public function get_icon()
    {
        return 'eicon-paint-brush';
    }

    public function get_categories()
    {
        return ['emperor-footer-elements'];
    }

    protected function _register_controls()
    {


        $this->start_controls_section(
            'developer_section',
            [
                'label' => esc_html__('تنظیمات طراح', 'emperor'),
                'type' => Controls_Manager::SECTION,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('عنوان', 'emperor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'طراحی و توسعه: کلون کلود',

            ]
        );

        $this->add_control(
            'url',
            [
                'label' => __('لینک', 'emperor'),
                'type' => \Elementor\Controls_Manager::URL,
            ]
        );

        $this->end_controls_section();
    }

    protected function render($instance = [])
    {
        $settings = $this->get_settings_for_display();

        ?>


        <div class="keloncloud-developer">
            <a href="<?php echo esc_url($settings['url']['url']) ?>">
                <i class="fal fa-code"></i>
                <span><?php echo $settings['title'] ?></span>
            </a>
        </div>

    <?php }

}

Plugin::instance()->widgets_manager->register_widget_type(new keloncloud_Widget_developer);
