<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

class keloncloud_Widget_cart_icon extends Widget_Base
{

    public function get_name()
    {
        return 'cart_icon';
    }

    public function get_title()
    {
        return esc_html__('سبد خرید', 'emperor');
    }

    public function get_icon()
    {
        return 'eicon-cart';
    }

    public function get_categories()
    {
        return ['emperor-header-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'cart_btn_section',
            [
                'label' => esc_html__('آیکون سبد خرید', 'emperor'),
                'type' => Controls_Manager::SECTION,
            ]
        );

        $this->add_control(
            'border',
            [
                'label' => __( 'گوشه های گرد (px)', 'elementor' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'به پیکسل', 'elementor' ),
                'default' => __( '5', 'elementor' ),
            ]
        );
        $this->add_control(
            'fontsize',
            [
                'label' => __( 'سایز آیکون (px)', 'elementor' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'به پیکسل', 'elementor' ),
                'default' => __( '20', 'elementor' ),
            ]
        );
        $this->add_control(
            'back',
            [
                'label' => __( 'پس زمینه', 'emperor' ),
                'type' => Controls_Manager::COLOR,
            ]
        );
        $this->add_control(
            'color',
            [
                'label' => __( 'رنگ', 'emperor' ),
                'type' => Controls_Manager::COLOR,
            ]
        );

        $this->end_controls_section();
    }

    protected function render($instance = [])
    {
        $settings = $this->get_settings_for_display();
        global $post;

        // get_post_type($post->ID) != 'keloncloudheader'
        ?>



        <div class="top-bar-cart cart" style="background: <?php echo $settings['back'] ?> !important; border-radius: <?php echo $settings['border'] ?>px !important;">
            <a href="<?php echo wc_get_cart_url(); ?>" class="mini-cart-opener" >
                   <span>
                        <i class="fal fa-shopping-bag" style="color: <?php echo $settings['color'] ?> !important; font-size: <?php echo $settings['fontsize'] ?>px !important; "></i>
                   </span>
                <?php keloncloud_cart_count(); ?>
            </a>
            <div class="dropdown-cart">
                <?php

                echo '<div class="widget woocommerce widget_shopping_cart"><div class="widget_shopping_cart_content"></div></div>';

                ?>
            </div>
        </div>


        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new keloncloud_Widget_cart_icon);
