<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class keloncloud_Widget_Blog extends Widget_Base {

   public function get_name() {
      return 'blog';
   }

   public function get_title() {
      return esc_html__( 'آخرین مطالب', 'emperor' );
   }

   public function get_icon() {
        return 'eicon-posts-carousel';
   }

   public function get_categories() {
      return [ 'emperor-elements' ];
   }
   protected function _register_controls() {
      $this->start_controls_section(
         'blog_section',
         [
            'label' => esc_html__( 'Blog', 'emperor' ),
            'type' => Controls_Manager::SECTION,
         ]
      );

	  $this->add_control(
         'pppp',
         [
            'label' => __( 'Number of Items', 'emperor' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
               'no' => [
                  'min' => 1,
                  'max' => 100,
                  'step' => 1,
               ],
            ],
            'default' => [
               'size' => 3,
            ]
         ]
      );

	  $this->add_control(
         'columns',
         [
            'label' => __( 'Columns', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'col-md-4',
            'options' => [
               'col-md-12'  => __( 'Column 1', 'emperor' ),
               'col-md-6' => __( 'Column 2', 'emperor' ),
               'col-md-4' => __( 'Column 3', 'emperor' ),
               'col-md-3' => __( 'Column 4', 'emperor' ),
               'col-md-2' => __( 'Column 6', 'emperor' ),
               'col-md-1' => __( 'Column 12', 'emperor' ),
            ],
         ]
      );


	  $this->add_control(
         'category',
         [
            'label' => esc_html__( 'Category', 'emperor' ),
            'type' => Controls_Manager::SELECT2,
            'title' => esc_html__( 'Select a category', 'emperor' ),
            'multiple' => true,
            'options' => keloncloud_get_terms_dropdown_array([
               'taxonomy' => 'category',
               'hide_empty' => false,
            ]),
         ]
      );

	  $this->add_control(
         'order',
         [
            'label' => __( 'Order', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'DESC',
            'options' => [
               'ASC'  => __( 'Ascending', 'emperor' ),
               'DESC' => __( 'Descending', 'pelleh' )
            ],
         ]
      );

      $this->end_controls_section();
   }

   protected function render( $instance = [] ) {

      // get our input from the widget settings.

      $settings = $this->get_settings_for_display();

	  $category = !empty( $settings['category'] ) ? $settings['category'] : 'All';

      //Inline Editing
      $this->add_inline_editing_attributes( 'ppp', 'basic' );
      ?>

      <div class="container blog-grid-elementor">
         <div class="row elementor-blog blog-loop-inner blog-loop-view-grid">
            <?php
            $blog = new \WP_Query( array(
               'post_type' => 'post',
               'posts_per_page' => $settings['pppp']['size'],
               'ignore_sticky_posts' => true,
               'order' => $settings['order'],
			   'tax_query'     => array(
                 array(
                     'taxonomy'  => 'category',
                     'field'     => 'id',
                     'terms'     => $category
                 )
             )
            ));
            /* Start the Loop */
            while ( $blog->have_posts() ) : $blog->the_post();
            ?>
            <!-- blog -->
            <div class="<?php echo esc_attr($settings['columns']) ?>">
               <?php get_template_part( '/inc/templates/blog/grid-postbit', get_post_format() ); ?>
            </div>
            <?php
            endwhile;
            wp_reset_postdata();
            ?>
         </div>
      </div>
      <?php
   }

}
Plugin::instance()->widgets_manager->register_widget_type( new keloncloud_Widget_Blog );
