<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class keloncloud_Widget_Blog_Video extends Widget_Base {

   public function get_name() {
      return 'blog-video';
   }

   public function get_title() {
      return esc_html__( 'آخرین ویدئوها', 'emperor' );
   }

   public function get_icon() {
        return 'eicon-posts-carousel';
   }

   public function get_categories() {
      return [ 'emperor-elements' ];
   }
   protected function _register_controls() {
      $this->start_controls_section(
         'blog_section',
         [
            'label' => esc_html__( 'Blog', 'emperor' ),
            'type' => Controls_Manager::SECTION,
         ]
      );

	  $this->add_control(
         'pppp',
         [
            'label' => __( 'Number of Items', 'emperor' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
               'no' => [
                  'min' => 1,
                  'max' => 100,
                  'step' => 1,
               ],
            ],
            'default' => [
               'size' => 3,
            ]
         ]
      );



	  $this->add_control(
         'category',
         [
            'label' => esc_html__( 'Category', 'emperor' ),
            'type' => Controls_Manager::SELECT2,
            'title' => esc_html__( 'Select a category', 'emperor' ),
            'multiple' => true,
            'options' => keloncloud_get_terms_dropdown_array([
               'taxonomy' => 'category',
               'hide_empty' => false,
            ]),
         ]
      );

	  $this->add_control(
         'order',
         [
            'label' => __( 'Order', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'DESC',
            'options' => [
               'ASC'  => __( 'Ascending', 'emperor' ),
               'DESC' => __( 'Descending', 'emperor' )
            ],
         ]
      );

      $this->end_controls_section();
   }

    protected function render($instance = [])
    {

        $settings = $this->get_settings_for_display();

        $category = !empty($settings['category']) ? $settings['category'] : 'All';

        //Inline Editing
        $this->add_inline_editing_attributes('ppp', 'basic');
        ?>


        <?php
        $query = new \WP_Query(array(
            'post_type' => 'post',
            'posts_per_page' => $settings['pppp']['size'],
            'ignore_sticky_posts' => true,
            'order' => $settings['order'],
            'tax_query' => array(
                array(
                    'taxonomy' => 'category',
                    'field' => 'id',
                    'terms' => $category
                )
            )
        ));

        ?>


        <div class="keloncloud-tamasha-grid">

            <div class="keloncloud-extra-video-col">
                <div class="tab-content">
                    <?php $i = 0;
                    while ($query->have_posts()) : $query->the_post();
                        $i++; ?>
                        <div class="tab-pane ts-overlay-style fade <?php echo esc_attr(($i == 1) ? 'show active' : ''); ?>"
                             id="nav-post-tab-<?php echo esc_attr($this->get_id()); ?>-<?php echo esc_attr($i); ?>"
                             role="tabpanel"
                             aria-labelledby="nav-<?php echo esc_attr($this->get_id()); ?>-<?php echo esc_attr($i); ?>-tab">
                            <?php

                            $prefix = '_keloncloud_';
                            $video_post_id = get_post_meta(get_the_ID(), $prefix . 'video_post_id', true);
                            $poster_video_post_id = get_post_meta(get_the_ID(), $prefix . 'poster_video_post_id', true);

                            $attr = array(
                                'mp4' => $video_post_id,
                                'poster' => $poster_video_post_id,
                                'preload' => 'auto',
                                'width' => '800',
                                'height' => '400'
                            );
                            echo wp_video_shortcode($attr);
                            ?>
                        </div>
                    <?php endwhile;
                    wp_reset_query(); ?>
                </div>
            </div>
            <div class="keloncloud-list-col">
                <div class="keloncloud-list-video-grid nav post-list-box" id="nav-tab" role="tablist">
                    <?php $i = 0;
                    while ($query->have_posts()) : $query->the_post();
                        $i++; ?>
                        <a class="nav-item nav-link <?php echo esc_attr(($i == 1) ? 'active' : ''); ?>"
                           id="nav-<?php echo esc_attr($this->get_id()); ?>-<?php echo esc_attr($i); ?>-tab"
                           data-toggle="tab"
                           href="#nav-post-tab-<?php echo esc_attr($this->get_id()); ?>-<?php echo esc_attr($i); ?>"
                           role="tab"
                           aria-controls="nav-post-tab-<?php echo esc_attr($this->get_id()); ?>-<?php echo esc_attr($i); ?>"
                           aria-selected="true">
                            <div class="post-content media">
                                <?php the_post_thumbnail('metro_others'); ?>
                                <div class="media-body align-self-center">
                                    <h4 class="post-title"><?php the_title(); ?></h4>
                                    <span class="keloncloud-post-date">
                                                <i class="fa fa-clock-o"></i>
                                                <?php echo get_the_date(); ?>
                                            </span>
                                </div>
                            </div>
                        </a>
                    <?php endwhile;
                    wp_reset_query(); ?>
                </div>
            </div>

        </div>

        <?php
    }

}
Plugin::instance()->widgets_manager->register_widget_type( new keloncloud_Widget_Blog_Video );
