<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class keloncloud_Widget_Blog_Podcast extends Widget_Base {

    public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);

        global $theme_version;
        $theme_obj     = wp_get_theme();
        $theme_version = $theme_obj->get( 'Version' );

        wp_register_style('emperor-testimonials-swiper-css', get_theme_file_uri('assets/css/swiper.min.css'));
        wp_register_script('emperor-testimonials-swiper-js', get_theme_file_uri('assets/js/vendor/swiper.min.js'), ['elementor-frontend'], $theme_version, true);
        wp_register_script( 'emperor-blog-podcast-handle', get_theme_file_uri( 'assets/js/elementor/blog-podcast.js' ) , [ 'elementor-frontend' ], $theme_version, true );
    }

   public function get_name() {     
      return 'blog-podcast';
   }

   public function get_title() {
      return esc_html__( 'آخرین پادکست ها', 'emperor' );
   }

   public function get_icon() {
        return 'eicon-posts-carousel';
   }

   public function get_categories() {
      return [ 'emperor-elements' ];
   }
   protected function _register_controls() {
      $this->start_controls_section(
         'blog_section',
         [
            'label' => esc_html__( 'Blog', 'emperor' ),
            'type' => Controls_Manager::SECTION,
         ]
      );

	  $this->add_control(
         'pppp',
         [
            'label' => __( 'Number of Items', 'emperor' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
               'no' => [
                  'min' => 1,
                  'max' => 100,
                  'step' => 1,
               ],
            ],
            'default' => [
               'size' => 3,
            ]
         ]
      );



	  $this->add_control(
         'category',
         [
            'label' => esc_html__( 'Category', 'emperor' ),
            'type' => Controls_Manager::SELECT2,
            'title' => esc_html__( 'Select a category', 'emperor' ),
            'multiple' => true,
            'options' => keloncloud_get_terms_dropdown_array([
               'taxonomy' => 'category',
               'hide_empty' => false,
            ]),
         ]
      );

	  $this->add_control(
         'order',
         [
            'label' => __( 'Order', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'DESC',
            'options' => [
               'ASC'  => __( 'Ascending', 'emperor' ),
               'DESC' => __( 'Descending', 'pelleh' )
            ],
         ]
      );

      $this->end_controls_section();
   }

    protected function render( $instance = [] ) {

        $settings = $this->get_settings_for_display();

        $category = !empty( $settings['category'] ) ? $settings['category'] : 'All';

        //Inline Editing
        $this->add_inline_editing_attributes( 'ppp', 'basic' );
        ?>



        <div class="keloncloud-blog-slider">
            <div class="blog-slider__wrp swiper-wrapper">

                <?php
                $blog = new \WP_Query( array(
                    'post_type' => 'post',
                    'posts_per_page' => $settings['pppp']['size'],
                    'ignore_sticky_posts' => true,
                    'order' => $settings['order'],
                    'tax_query'     => array(
                        array(
                            'taxonomy'  => 'category',
                            'field'     => 'id',
                            'terms'     => $category
                        )
                    )
                ));

                while ( $blog->have_posts() ) : $blog->the_post();
                    ?>
                    <div class="blog-slider__item swiper-slide">
                        <div class="blog-slider__content">
                            <span class="blog-slider__code"><i class="fal fa-clock"></i><?php echo get_the_date(); ?></span>
                            <div class="blog-slider__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
                            <div class="blog-slider__text">
                                <?php
                                if( has_excerpt() ){
                                    $content = the_excerpt();
                                } else {
                                    echo wp_trim_words( get_the_content(), 15, '...' );
                                }
                                ?>
                            </div>
                            <div class="dabir-podcast">
                                <?php
                                $prefix = '_keloncloud_';
                                $audio_post_id = get_post_meta(get_the_ID(), $prefix . 'audio_post_id', true);
                                $attr =  array(
                                    'mp3'      => $audio_post_id,
                                );
                                echo wp_audio_shortcode(  $attr );
                                ?>
                            </div>
                            <div class="keloncloud-blog-slider__pagination"></div>

                        </div>
                        <div class="blog-slider__img">
                            <?php the_post_thumbnail('keloncloud-image-400x400-croped'); ?>
                        </div>
                    </div>

                <?php
                endwhile;
                wp_reset_postdata();
                ?>

            </div>

        </div>

        <?php
    }

    public function get_script_depends() {
        return [ 'keloncloud-theme', 'emperor-blog-podcast-handle' ];
    }

}
Plugin::instance()->widgets_manager->register_widget_type( new keloncloud_Widget_Blog_Podcast );
