<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class keloncloud_Widget_Blog_Pele extends Widget_Base {

   public function get_name() {
      return 'blog_pele';
   }

   public function get_title() {
      return esc_html__( 'آخرین مطالب پلکانی', 'emperor' );
   }

   public function get_icon() {
        return 'eicon-posts-carousel';
   }

   public function get_categories() {
      return [ 'emperor-elements' ];
   }
   protected function _register_controls() {
      $this->start_controls_section(
         'blog_section',
         [
            'label' => esc_html__( 'Blog', 'emperor' ),
            'type' => Controls_Manager::SECTION,
         ]
      );


	  $this->add_control(
         'category',
         [
            'label' => esc_html__( 'Category', 'emperor' ),
            'type' => Controls_Manager::SELECT2,
            'title' => esc_html__( 'Select a category', 'emperor' ),
            'multiple' => true,
            'options' => keloncloud_get_terms_dropdown_array([
               'taxonomy' => 'category',
               'hide_empty' => false,
            ]),
         ]
      );

	  $this->add_control(
         'order',
         [
            'label' => __( 'Order', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'DESC',
            'options' => [
               'ASC'  => __( 'Ascending', 'emperor' ),
               'DESC' => __( 'Descending', 'pelleh' )
            ],
         ]
      );

      $this->end_controls_section();
   }

   protected function render( $instance = [] ) {

      // get our input from the widget settings.

      $settings = $this->get_settings_for_display();

	  $category = !empty( $settings['category'] ) ? $settings['category'] : 'All';

      ?>

      <div class="container blog-grid-elementor blog-pele">
         <div class="row elementor-blog blog-loop-inner blog-loop-view-grid">
            <?php
            $blog = new \WP_Query( array(
               'post_type' => 'post',
               'posts_per_page' => 4,
               'ignore_sticky_posts' => true,
               'order' => $settings['order'],
			   'tax_query'     => array(
                 array(
                     'taxonomy'  => 'category',
                     'field'     => 'id',
                     'terms'     => $category
                 )
             )
            ));
            $count = 0;
            /* Start the Loop */
            while ( $blog->have_posts() ) : $blog->the_post();
                $count++;
            ?>
            <!-- blog -->
            <div class="col-md-6 <?php echo $count == 1 || $count == 3 ? 'mt-4' : '' ?>">
               <?php get_template_part( '/inc/templates/blog/grid-post-pele', get_post_format() ); ?>
            </div>
            <?php
            endwhile;
            wp_reset_postdata();
            ?>
         </div>
      </div>
      <?php
   }

}
Plugin::instance()->widgets_manager->register_widget_type( new keloncloud_Widget_Blog_Pele );
