<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class keloncloud_Widget_Blog_Carousel extends Widget_Base {

    public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);

        global $theme_version;
        $theme_obj     = wp_get_theme();
        $theme_version = $theme_obj->get( 'Version' );

        wp_register_script( 'emperor-blog-carousel-handle', get_theme_file_uri( 'assets/js/elementor/blog-carousel.js' ) , [ 'elementor-frontend' ], $theme_version, true );
    }


    public function get_name() {
      return 'blog-carousel';
   }

   public function get_title() {
      return esc_html__( 'کروسل آخرین مطالب', 'emperor' );
   }

   public function get_icon() {
        return 'eicon-posts-carousel';
   }

   public function get_categories() {
      return [ 'emperor-elements' ];
   }
   protected function _register_controls() {
      $this->start_controls_section(
         'blog_section',
         [
            'label' => esc_html__( 'Blog', 'emperor' ),
            'type' => Controls_Manager::SECTION,
         ]
      );

	  $this->add_control(
         'pppp',
         [
            'label' => __( 'Number of Items', 'emperor' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
               'no' => [
                  'min' => 1,
                  'max' => 100,
                  'step' => 1,
               ],
            ],
            'default' => [
               'size' => 3,
            ]
         ]
      );

	  $this->add_control(
         'columns',
         [
            'label' => __( 'Columns', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => '2',
            'options' => [
               '4'  => __( '4 ستونه', 'emperor' ),
               '3' => __( '3 ستونه', 'emperor' ),
               '2' => __( '2 ستونه', 'emperor' ),
            ],
         ]
      );

	  $this->add_control(
         'pagination',
         [
            'label' => __( 'صفحه گذاری اسلایدر', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'yes',

         ]
      );

	  $this->add_control(
         'navigation',
         [
            'label' => __( 'فلش های ناوبری', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'yes',

         ]
      );

	  $this->add_control(
         'loop',
         [
            'label' => __( 'حلقه کروسل', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'yes',

         ]
      );

	  $this->add_control(
         'autoplay',
         [
            'label' => __( 'اجرای خودکار اسلایدر', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'yes',

         ]
      );


	  $this->add_control(
         'category',
         [
            'label' => esc_html__( 'Category', 'emperor' ),
            'type' => Controls_Manager::SELECT2,
            'title' => esc_html__( 'Select a category', 'emperor' ),
            'multiple' => true,
            'options' => keloncloud_get_terms_dropdown_array([
               'taxonomy' => 'category',
               'hide_empty' => false,
            ]),
         ]
      );

	  $this->add_control(
         'order',
         [
            'label' => __( 'Order', 'emperor' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'DESC',
            'options' => [
               'ASC'  => __( 'Ascending', 'emperor' ),
               'DESC' => __( 'Descending', 'pelleh' )
            ],
         ]
      );

      $this->end_controls_section();
   }

   protected function render( $instance = [] ) {


      $settings = $this->get_settings_for_display();
	  $carousel_data = array();
	  $carousel_data['data-slider-items'] = $settings['columns'];
	  $carousel_data['data-pagination'] = $settings['pagination'];
	  $carousel_data['data-navigation'] = $settings['navigation'];
	  $carousel_data['data-loop'] = $settings['loop'];
	  $carousel_data['data-autoplay'] = $settings['autoplay'];

	  $category = !empty( $settings['category'] ) ? $settings['category'] : 'All';

      //Inline Editing
      $this->add_inline_editing_attributes( 'ppp', 'basic' );
      ?>


         <div class="blog-posts-holder">
			<div class="owl-carousel" <?php echo keloncloud_get_inline_attrs( $carousel_data ); ?>>
            <?php
            $blog = new \WP_Query( array(
               'post_type' => 'post',
               'posts_per_page' => $settings['pppp']['size'],
               'ignore_sticky_posts' => true,
               'order' => $settings['order'],
			         'tax_query'     => array(
                 array(
                     'taxonomy'  => 'category',
                     'field'     => 'id',
                     'terms'     => $category
                 )
             )
            ));

            while ( $blog->have_posts() ) : $blog->the_post();
            ?>
			<div class="blog-loop-inner">
               <?php get_template_part( '/inc/templates/blog/grid-postbit', get_post_format() ); ?>
			</div>
            <?php
            endwhile;
            wp_reset_postdata();
            ?>
			</div>
		 </div>

      <?php
   }


    public function get_script_depends() {
        return [ 'keloncloud-theme', 'emperor-blog-carousel-handle' ];
    }

}
Plugin::instance()->widgets_manager->register_widget_type( new keloncloud_Widget_Blog_Carousel );
