<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class keloncloud_Widget_Background extends Widget_Base {

    public function get_name() {
        return 'emperor-background';
    }

    public function get_title() {
        return esc_html__( 'پس زمینه اختصاصی', 'emperor' );
    }

    public function get_icon() {
        return 'eicon-posts-carousel';
    }

    public function get_categories() {
        return [ 'emperor-elements' ];
    }
    protected function _register_controls() {
        $this->start_controls_section(
            'emperor_bg_section',
            [
                'label' => esc_html__( 'پس زمینه اختصاصی', 'emperor' ),
                'type' => Controls_Manager::SECTION,
            ]
        );

        $this->add_control(
            'bg-type',
            [
                'label' => esc_html__( 'نوع پس زمینه', 'emperor' ),
                'type' => Controls_Manager::SELECT2,
                'title' => esc_html__( 'یک گزینه را انتخاب کنید', 'emperor' ),
                'options' => [
                    'shape-bg'  => __( 'پس زمینه یک', 'emperor' ),
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render( $instance = [] ) {

        $settings = $this->get_settings_for_display(); ?>

        <div class="dabir-bg position-relative">
            <div class="<?php echo esc_attr($settings['bg-type']) ?>"></div>
        </div>

        <?php
    }

}

Plugin::instance()->widgets_manager->register_widget_type( new keloncloud_Widget_Background );
