<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;


class keloncloud_Widget_access_menu extends Widget_Base
{
    public function get_name()
    {
        return 'access_menu';
    }

    public function get_title()
    {
        return esc_html__('دسترسی سریع', 'emperor');
    }

    public function get_icon()
    {
        return 'eicon-editor-list-ul';
    }

    public function get_categories()
    {
        return ['emperor-header-elements'];
    }

    protected function _register_controls()
    {


        $this->start_controls_section(
            'access_menu_section',
            [
                'label' => esc_html__('تنظیمات منو', 'emperor'),
                'type' => Controls_Manager::SECTION,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('عنوان', 'emperor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'دسترسی سریع',

            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label' => __('زیر عنوان', 'emperor'),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __('انتخاب تصویر', 'emperor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],

            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'links_section',
            [
                'label' => esc_html__('آیتم ها', 'emperor'),
                'type' => Controls_Manager::SECTION,
            ]
        );

        $repeater = new \Elementor\Repeater();



        $repeater->add_control(
            'title',
            [
                'label' => __('عنوان', 'emperor'),
                'type' => \Elementor\Controls_Manager::TEXT,

            ]
        );


        $repeater->add_control(
            'icon',
            [
                'label' => __('انتخاب تصویر', 'emperor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],

            ]
        );


        $repeater->add_control(
            'url',
            [
                'label' => __('لینک', 'emperor'),
                'type' => \Elementor\Controls_Manager::URL
            ]
        );

        $this->add_control(
            'links',
            [
                'label' => __('آیتم های منو', 'emperor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{title}}}',

            ]
        );


        $this->end_controls_section();


    }

    protected function render($instance = [])
    {
        $settings = $this->get_settings_for_display();

        global $post;
        ?>

            <div class="access-menu">
            <div class="holder">
                <img src="<?php echo $settings['image']['url'] ?>">
                <span><?php echo $settings['title']; ?></span>
            </div>
            <div class="drop">
                <?php if ($settings['subtitle'] != ''): ?>
                    <div class="subtitle">
                        <?php echo $settings['subtitle']; ?>
                    </div>
                <?php endif; ?>

                <ul>
                    <?php foreach ($settings['links'] as $link): ?>
                        <li>
                            <a href="<?php echo esc_url($link['url']['url']) ?>">
                                <img src="<?php echo $link['icon']['url'] ?>">
                                <span><?php echo $link['title'] ?></span>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>


    <?php }

}

Plugin::instance()->widgets_manager->register_widget_type(new keloncloud_Widget_access_menu);
