<?php
/**
Theme Designed By: Herowp
Email: keloncloud.com@gmail.com
Author Website: https://www.rtl-theme.com/user-profile/ah-ashrafi/
 */

if ( ! defined( 'ABSPATH' ) ) exit;

if( ! function_exists("keloncloud_elementor_teacher_list") ){
    function keloncloud_elementor_teacher_list(){

        $staff_query  = query_posts('posts_per_page=-1&post_type=teacher&orderby=title&order=ASC'); // Products
        $staff_array = array();

        if(is_array($staff_array)){
            foreach ($staff_query as $staff ) {	// add product posts to the list
                $staff_array[$staff->ID] = $staff->post_title;
            }
        }

        wp_reset_query();
        return $staff_array;
    }
}


// get posts dropdown
function keloncloud_get_posts_dropdown_array($args = [], $key = 'ID', $value = 'post_title') {
    $options = [];
    $posts = get_posts($args);
    foreach ((array) $posts as $term) {
        $options[$term->{$key}] = $term->{$value};
    }
    return $options;
}

// get terms dropdown
function keloncloud_get_terms_dropdown_array($args = [], $key = 'term_id', $value = 'name') {
    $options = [];
    $terms = get_terms($args);

    if (is_wp_error($terms)) {
        return [];
    }

    foreach ((array) $terms as $term) {
        $options[$term->{$key}] = $term->{$value};
    }

    return $options;
}

// Add Elementor Category
function keloncloud_add_elementor_widget_categories( $elements_manager ) {

    $elements_manager->add_category(
        'emperor-elements',
        [
            'title' => esc_html__( 'المان اصلی امپراطور', 'emperor' ),
            'icon' => 'fa fa-plug',
        ]
    );
    $elements_manager->add_category(
        'emperor-header-elements',
        [
            'title' => esc_html__( 'المان هدر امپراطور', 'emperor' ),
            'icon' => 'fa fa-plug',
        ]
    );
    $elements_manager->add_category(
        'emperor-footer-elements',
        [
            'title' => esc_html__( 'المان فوتر امپراطور', 'emperor' ),
            'icon' => 'fa fa-plug',
        ]
    );
    $elements_manager->add_category(
        'emperor-product-elements',
        [
            'title' => esc_html__( 'المان محصول امپراطور', 'emperor' ),
            'icon' => 'fa fa-plug',
        ]
    );

}
add_action( 'elementor/elements/categories_registered', 'keloncloud_add_elementor_widget_categories' );

// Elementor init
class keloncloud_ElementorCustomElement {

    private static $instance = null;

    public static function get_instance() {
        if ( ! self::$instance )
            self::$instance = new self;
        return self::$instance;
    }

    public function init(){
        add_action( 'elementor/widgets/widgets_registered', array( $this, 'widgets_registered' ) );
    }


    public function widgets_registered() {
        if(defined('ELEMENTOR_PATH') && class_exists('Elementor\Widget_Base')){
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-search.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-heading.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-products.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-products-icon.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-testimonials.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-testimonials-swiper.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-products-carousel.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-paths-carousel.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-products-icon-carousel.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-blog.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-blog-pele.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-blog-carousel.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-blog-metro.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-blog-small-metro.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-blog-podcast.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-blog-video.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-products-teacher.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-download.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-background.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-lessons.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-blog-attach.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-dividers.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-slider.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-access-menu.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-auth-btn.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-cart-icon.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-search-btn.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-footer-menu.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-header-menu.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-namad-slider.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-phone-btn.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-advice-btn.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-developer.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-special.php' );

            // product
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-bread.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-category.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-title.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-desc.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-rate.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-cover.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-sell.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-comment-count.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-view.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-shortlink.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-seller.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-related.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-rate-main.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-advice-btn.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-comment.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-tag.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-location.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-wishlist.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-simple-addtocart.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-addtocart-btn.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-share.php' );
            require_once get_parent_theme_file_path( '/inc/lib/wg/widget-product-amazing.php' );
        }
    }

}

keloncloud_ElementorCustomElement::get_instance()->init();
