<?php
/**
Theme Designed By: Herowp
Email: keloncloud.com@gmail.com
Author Website: https://www.rtl-theme.com/user-profile/ah-ashrafi/
 */
?> <!DOCTYPE html>
<html itemscope itemtype="http://schema.org/WebPage" <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no"/>
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">


    <?php
        $custom_css = keloncloud_option('emperor_custom_css');
    ?>
    <?php if ( (isset($custom_css)) && strlen( $custom_css ) > 0 ) : ?>
        <style>
            <?php echo $custom_css; ?>
        </style>
    <?php endif; ?>

    <?php wp_head(); ?>

</head>
<?php
$emepror_overlay = 'emperor-overlay-2';
if(keloncloud_option('search-style')){
    $emepror_overlay = 'emperor-overlay-'.keloncloud_option('search-style');
}

?>
<body <?php body_class(); ?> data-emperor-overlay="<?php echo esc_html( $emepror_overlay ); ?>">

<?php do_action('keloncloud_before_body'); ?>

<?php

$prefix = '_keloncloud_';
$notification_bar_display = get_post_meta(get_the_ID(), $prefix . 'notification_bar_off', true);

$account_link = get_permalink(get_option('woocommerce_myaccount_page_id'));

?>

<div class="video_popup_wrrapper">
    <div class="video_popup_overlay">
        <i class="fal fa-times close-video-popup"></i>
    </div>
    <div class="video_popup_inner"></div>
</div>

<?php if (!is_user_logged_in()) : ?>
    <div class="my-modal">
        <div class="login-form-overlay"></div>
        <div class="login-form-modal">
            <div class="login-form-modal-inner">
                <div class="login-form-modal-box">
                    <a href="javascript:void(0)" class="close">
                        <?php get_template_part('/assets/images/close-icon.svg'); ?>
                    </a>
                    <div class="login-form-header">
                        <p class="login-title"><?php esc_html_e('Sign In', 'emperor'); ?></p>
                    </div>
                    <div class="login-form-content">
                        <?php get_template_part('/inc/templates/login-modal'); ?>
                        <?php printf(
                            esc_html__('Not a member yet? %1$sSign Up%2$s', 'emperor'),
                            '<a href="' . esc_url($account_link) . '"><strong>',
                            '</strong></a>'
                        ); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>


<?php if (keloncloud_needs_header()): ?>

        <?php if (!$notification_bar_display): ?>
            <?php get_template_part('/inc/templates/header/notification-bar'); ?>
        <?php endif; ?>

        <?php get_template_part('/inc/templates/header/main-header');?>

        <?php get_template_part('/inc/templates/page-title'); ?>

<?php endif; ?>
