jQuery(window).on("elementor/frontend/init", () => {
    elementorFrontend.hooks.addAction("frontend/element_ready/testimonials.default", e => {
        var carousel = jQuery('.testimonials-wrapper .owl-carousel');
        if (carousel.length) {

            carousel.each(function () {

                var owl = jQuery(this),
                    autoplay = owl.data('autoplay'),
                    pagination = owl.data('pagination') ? owl.data('pagination') : false,
                    loop = owl.data('loop');

                owl.owlCarousel({
                    center: true,
                    items: 2,
                    responsive: {
                        200: {
                            items: 1
                        },
                        400: {
                            items: 1
                        },
                        900: {
                            items: 2
                        }
                    },
                    dots: pagination,
                    nav: true,
                    rtl: true,
                    autoheight: true,
                    autoplay: autoplay,
                    navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
                    loop: loop,
                });

            });
        }
    })
});