jQuery(window).on("elementor/frontend/init", () => {
    elementorFrontend.hooks.addAction("frontend/element_ready/Carousel_Products.default", e => {
        var carousel = jQuery('.courses-holder .owl-carousel');
        if (carousel.length) {

            carousel.each(function () {
                var owl = jQuery(this),
                    autoplay = owl.data('autoplay'),
                    pagination = owl.data('pagination') ? owl.data('pagination') : false,
                    navigation = owl.data('navigation') ? owl.data('navigation') : false,
                    loop = owl.data('loop'),
                    slide_items = owl.data('slider-items');

                owl.owlCarousel({
                    items: slide_items,
                    margin: 10,
                    responsive: {
                        979: {
                            items: slide_items
                        },
                        768: {
                            items: 2
                        },
                        479: {
                            items: 1
                        },
                        0: {
                            items: 1
                        }
                    },
                    dots: pagination,
                    nav: navigation,
                    autoplay: autoplay,
                    autoheight: true,
                    navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
                    rtl: true,
                    loop: loop,
                });
            });

        }
    })
});