const slides = document.querySelector('.slides');
const slideCount = document.querySelectorAll('.slide').length;
const prevBtn = document.querySelector('.prev');
const nextBtn = document.querySelector('.next');
const dotsContainer = document.querySelector('.dots');
const slider = document.getElementById('slider');

let index = 0;
let interval;

// ساخت دات‌ها
for (let i = 0; i < slideCount; i++) {
    const dot = document.createElement('span');
    dot.classList.add('dot');
    dot.addEventListener('click', () => goToSlide(i));
    dotsContainer.appendChild(dot);
}

const dots = document.querySelectorAll('.dot');

function updateSlider() {
    slides.style.transform = `translateX(-${index * 100}%)`;
    dots.forEach(dot => dot.classList.remove('active'));
    dots[index].classList.add('active');
}

function nextSlide() {
    index = (index + 1) % slideCount;
    updateSlider();
}

function prevSlide() {
    index = (index - 1 + slideCount) % slideCount;
    updateSlider();
}

function goToSlide(i) {
    index = i;
    updateSlider();
}

// اتوماتیک
function startAutoSlide() {
    interval = setInterval(nextSlide, 3000);
}

function stopAutoSlide() {
    clearInterval(interval);
}

// رویدادها
nextBtn.addEventListener('click', nextSlide);
prevBtn.addEventListener('click', prevSlide);

slider.addEventListener('mouseenter', stopAutoSlide);
slider.addEventListener('mouseleave', startAutoSlide);

// شروع
updateSlider();
startAutoSlide();
