<?php
/* Template Name: Tender */
get_header();
?>


<div class="page-wrap tender-landing">
    <div class="container">
        <div class="row">
            <div class="col-12 page-head">
                <h1 class="page-title wow fadeInUp" data-wow-delay="0.25s">
                    <?php echo get_the_title(); ?>
                </h1>
            </div>
            <div class="col-12 col-md-10 mx-auto">
<!--                <div class="default-editor mb-5">-->
<!--                    --><?php //the_content(); ?>
<!--                </div>-->
                <ul class="nav nav-tabs justify-content-center" id="tenderTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="tender-tab" data-bs-toggle="tab" data-bs-target="#tender"
                                type="button" role="tab" aria-controls="tender" aria-selected="true">
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/tab2.png" width="50"
                                 height="50" alt="مناقصه">
                            <span>مناقصه ها </span>
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="auction-tab" data-bs-toggle="tab" data-bs-target="#auction"
                                type="button" role="tab" aria-controls="auction" aria-selected="false">
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/tab1.png" width="50"
                                 height="50" alt="مزایده">
                            <span>مزایده ها</span>
                        </button>
                    </li>
                </ul>
                <div class="tab-content" id="tenderTabContent">
                    <?php
                    if (have_rows('add_tender')):
                        ?>
                        <div class="tab-pane fade show active" id="tender" role="tabpanel" aria-labelledby="tender-tab">
                            <div class="tender_list row">

                                <?php
                                while (have_rows('add_tender')) : the_row();
                                    $image = get_sub_field('image');
                                    $tender_title = get_sub_field('tender_title');
                                    $tender_desc = get_sub_field('tender_desc');
                                    $tender_link = get_sub_field('tender_link');
                                    $tender_date = get_sub_field('tender_date');
                                    ?>
                                    <div class="col-12 col-lg-6">
                                        <div class="tender_item">
                                            <div class="row">
                                                <?php if ($image) { ?>
                                                    <div class="col-12 col-sm-5 col-md-4">
                                                        <figure class="entry-media">
                                                            <img src="<?php echo $image['url']; ?>"
                                                                 width="<?php echo $image['width']; ?>"
                                                                 height="<?php echo $image['height']; ?>"
                                                                 alt="<?php echo $image['alt']; ?>">
                                                        </figure>
                                                    </div>
                                                <?php } ?>
                                                <div class="col-col-12 col-sm-7 col-md-8">
                                                    <div class="entry-content">
                                                        <?php
                                                        if ($tender_title != '') {
                                                            echo '<h3 class="entry-title">' . $tender_title . '</h3>';
                                                        }
                                                        if ($tender_desc != '') {
                                                            echo '<p>' . $tender_desc . '</p>';
                                                        }
                                                        echo '<div class="entry-meta">';
                                                        if ($tender_date != '') {
                                                            echo '<div class="date">
                                                        <span>تاریخ برگزاری : </span>
                                                        ' . $tender_date . '
                                                    </div>';
                                                        }
                                                        if ($tender_link != '') {
                                                            echo '<a href="' . $tender_link . '" class="theme-button download-btn">
                                                        <i class="icon-download"></i>
                                                        <span>دانلود فایل</span>
                                                    </a>';
                                                        }
                                                        echo '</div>';
                                                        ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endwhile; ?>
                            </div>
                        </div>
                    <?php endif;
                    if (have_rows('add_auction')):
                        ?>
                        <div class="tab-pane fade" id="auction" role="tabpanel" aria-labelledby="auction-tab">
                            <div class="tender_list row">
                                <?php
                                while (have_rows('add_auction')) : the_row();
                                    $auction_image = get_sub_field('auction_image');
                                    $auction_title = get_sub_field('auction_title');
                                    $auction_desc = get_sub_field('auction_desc');
                                    $auction_link = get_sub_field('auction_link');
                                    $auction_date = get_sub_field('auction_date');
                                    ?>
                                    <div class="col-12 col-lg-6">
                                        <div class="tender_item">
                                            <div class="row">
                                                <?php if ($auction_image) { ?>
                                                    <div class="col-12 col-sm-5 col-md-4">
                                                        <figure class="entry-media">
                                                            <img src="<?php echo $auction_image['url']; ?>"
                                                                 width="<?php echo $auction_image['width']; ?>"
                                                                 height="<?php echo $auction_image['height']; ?>"
                                                                 alt="<?php echo $auction_image['alt']; ?>">
                                                        </figure>
                                                    </div>
                                                <?php } ?>
                                                <div class="col-col-12 col-sm-7 col-md-8">
                                                    <div class="entry-content">
                                                        <?php
                                                        if ($auction_title != '') {
                                                            echo '<h3 class="entry-title">' . $auction_title . '</h3>';
                                                        }
                                                        if ($auction_desc != '') {
                                                            echo '<p>' . $auction_desc . '</p>';
                                                        }
                                                        echo '<div class="entry-meta">';
                                                        if ($auction_date != '') {
                                                            echo '<div class="date">
                                                        <span>تاریخ برگزاری : </span>
                                                        ' . $auction_date . '
                                                    </div>';
                                                        }
                                                        if ($auction_link != '') {
                                                            echo '<a href="' . $auction_link . '" class="theme-button download-btn">
                                                        <i class="icon-download"></i>
                                                        <span>دانلود فایل</span>
                                                    </a>';
                                                        }
                                                        echo '</div>';
                                                        ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endwhile; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php get_footer(); ?>

